/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.client;

import java.io.IOException;
import java.net.Socket;
import org.apache.http.shade.ConnectionReuseStrategy;
import org.apache.http.shade.HttpEntity;
import org.apache.http.shade.HttpException;
import org.apache.http.shade.HttpHost;
import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.HttpVersion;
import org.apache.http.shade.auth.AuthSchemeRegistry;
import org.apache.http.shade.auth.AuthScope;
import org.apache.http.shade.auth.AuthState;
import org.apache.http.shade.auth.Credentials;
import org.apache.http.shade.client.config.RequestConfig;
import org.apache.http.shade.client.params.HttpClientParamConfig;
import org.apache.http.shade.client.protocol.RequestClientConnControl;
import org.apache.http.shade.config.ConnectionConfig;
import org.apache.http.shade.conn.HttpConnectionFactory;
import org.apache.http.shade.conn.ManagedHttpClientConnection;
import org.apache.http.shade.conn.routing.HttpRoute;
import org.apache.http.shade.conn.routing.RouteInfo;
import org.apache.http.shade.entity.BufferedHttpEntity;
import org.apache.http.shade.impl.DefaultConnectionReuseStrategy;
import org.apache.http.shade.impl.auth.BasicSchemeFactory;
import org.apache.http.shade.impl.auth.DigestSchemeFactory;
import org.apache.http.shade.impl.auth.HttpAuthenticator;
import org.apache.http.shade.impl.auth.KerberosSchemeFactory;
import org.apache.http.shade.impl.auth.NTLMSchemeFactory;
import org.apache.http.shade.impl.auth.SPNegoSchemeFactory;
import org.apache.http.shade.impl.client.BasicCredentialsProvider;
import org.apache.http.shade.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.shade.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.shade.impl.execchain.TunnelRefusedException;
import org.apache.http.shade.message.BasicHttpRequest;
import org.apache.http.shade.params.BasicHttpParams;
import org.apache.http.shade.params.HttpParamConfig;
import org.apache.http.shade.params.HttpParams;
import org.apache.http.shade.protocol.BasicHttpContext;
import org.apache.http.shade.protocol.HttpProcessor;
import org.apache.http.shade.protocol.HttpRequestExecutor;
import org.apache.http.shade.protocol.ImmutableHttpProcessor;
import org.apache.http.shade.protocol.RequestTargetHost;
import org.apache.http.shade.protocol.RequestUserAgent;
import org.apache.http.shade.util.Args;
import org.apache.http.shade.util.EntityUtils;

public class ProxyClient {
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    private final ConnectionConfig connectionConfig;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final ProxyAuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthState proxyAuthState;
    private final AuthSchemeRegistry authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, ConnectionConfig connectionConfig, RequestConfig requestConfig) {
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.connectionConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new ImmutableHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new ProxyAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthState = new AuthState();
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        this.authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        this.authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        this.authSchemeRegistry.register("Negotiate", new SPNegoSchemeFactory());
        this.authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        this.reuseStrategy = new DefaultConnectionReuseStrategy();
    }

    @Deprecated
    public ProxyClient(HttpParams params) {
        this(null, HttpParamConfig.getConnectionConfig(params), HttpClientParamConfig.getRequestConfig(params));
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null);
    }

    @Deprecated
    public HttpParams getParams() {
        return new BasicHttpParams();
    }

    @Deprecated
    public AuthSchemeRegistry getAuthSchemeRegistry() {
        return this.authSchemeRegistry;
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        HttpEntity entity;
        int status;
        HttpResponse response;
        Args.notNull(proxy, "Proxy host");
        Args.notNull(target, "Target host");
        Args.notNull(credentials, "Credentials");
        HttpHost host = target;
        if (host.getPort() <= 0) {
            host = new HttpHost(host.getHostName(), 80, host.getSchemeName());
        }
        HttpRoute route = new HttpRoute(host, this.requestConfig.getLocalAddress(), proxy, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection conn = this.connFactory.create(route, this.connectionConfig);
        BasicHttpContext context = new BasicHttpContext();
        BasicHttpRequest connect = new BasicHttpRequest("CONNECT", host.toHostString(), HttpVersion.HTTP_1_1);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxy), credentials);
        context.setAttribute("http.target_host", target);
        context.setAttribute("http.connection", conn);
        context.setAttribute("http.request", connect);
        context.setAttribute("http.route", route);
        context.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
        context.setAttribute("http.auth.credentials-provider", credsProvider);
        context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        context.setAttribute("http.request-config", this.requestConfig);
        this.requestExec.preProcess(connect, this.httpProcessor, context);
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket);
            }
            this.authenticator.generateAuthResponse(connect, this.proxyAuthState, context);
            response = this.requestExec.execute(connect, conn, context);
            status = response.getStatusLine().getStatusCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            if (!this.authenticator.isAuthenticationRequested(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context) || !this.authenticator.handleAuthChallenge(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context)) break;
            if (this.reuseStrategy.keepAlive(response, context)) {
                entity = response.getEntity();
                EntityUtils.consume(entity);
            } else {
                conn.close();
            }
            connect.removeHeaders("Proxy-Authorization");
        }
        status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            entity = response.getEntity();
            if (entity != null) {
                response.setEntity(new BufferedHttpEntity(entity));
            }
            conn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        return conn.getSocket();
    }
}

