/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.conn;

import java.net.InetAddress;
import org.apache.http.shade.HttpException;
import org.apache.http.shade.HttpHost;
import org.apache.http.shade.HttpRequest;
import org.apache.http.shade.ProtocolException;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.client.config.RequestConfig;
import org.apache.http.shade.client.protocol.HttpClientContext;
import org.apache.http.shade.conn.SchemePortResolver;
import org.apache.http.shade.conn.UnsupportedSchemeException;
import org.apache.http.shade.conn.routing.HttpRoute;
import org.apache.http.shade.conn.routing.HttpRoutePlanner;
import org.apache.http.shade.impl.conn.DefaultSchemePortResolver;
import org.apache.http.shade.protocol.HttpContext;
import org.apache.http.shade.util.Args;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

