/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.cookie;

import java.util.Date;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.cookie.CommonCookieAttributeHandler;
import org.apache.http.shade.cookie.MalformedCookieException;
import org.apache.http.shade.cookie.SetCookie;
import org.apache.http.shade.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.shade.util.Args;

@Immutable
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + value);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

