/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.entity;

import org.apache.http.shade.HttpException;
import org.apache.http.shade.HttpMessage;
import org.apache.http.shade.ProtocolException;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.entity.ContentLengthStrategy;
import org.apache.http.shade.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

