/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.nio.client;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.shade.ConnectionReuseStrategy;
import org.apache.http.shade.HttpHost;
import org.apache.http.shade.auth.AuthSchemeProvider;
import org.apache.http.shade.auth.AuthState;
import org.apache.http.shade.client.CookieStore;
import org.apache.http.shade.client.CredentialsProvider;
import org.apache.http.shade.client.config.RequestConfig;
import org.apache.http.shade.client.protocol.HttpClientContext;
import org.apache.http.shade.concurrent.BasicFuture;
import org.apache.http.shade.concurrent.FutureCallback;
import org.apache.http.shade.config.Lookup;
import org.apache.http.shade.conn.ConnectionKeepAliveStrategy;
import org.apache.http.shade.cookie.CookieSpecProvider;
import org.apache.http.shade.impl.nio.client.CloseableHttpAsyncClientBase;
import org.apache.http.shade.impl.nio.client.DefaultClientExchangeHandlerImpl;
import org.apache.http.shade.impl.nio.client.InternalClientExec;
import org.apache.http.shade.nio.NHttpClientEventHandler;
import org.apache.http.shade.nio.conn.NHttpClientConnectionManager;
import org.apache.http.shade.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.shade.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.shade.protocol.BasicHttpContext;
import org.apache.http.shade.protocol.HttpContext;

class InternalHttpAsyncClient
extends CloseableHttpAsyncClientBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;
    private final InternalClientExec exec;
    private final Lookup<CookieSpecProvider> cookieSpecRegistry;
    private final Lookup<AuthSchemeProvider> authSchemeRegistry;
    private final CookieStore cookieStore;
    private final CredentialsProvider credentialsProvider;
    private final RequestConfig defaultConfig;

    public InternalHttpAsyncClient(NHttpClientConnectionManager connmgr, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy, ThreadFactory threadFactory, NHttpClientEventHandler handler, InternalClientExec exec, Lookup<CookieSpecProvider> cookieSpecRegistry, Lookup<AuthSchemeProvider> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig) {
        super(connmgr, threadFactory, handler);
        this.connmgr = connmgr;
        this.connReuseStrategy = connReuseStrategy;
        this.keepaliveStrategy = keepaliveStrategy;
        this.exec = exec;
        this.cookieSpecRegistry = cookieSpecRegistry;
        this.authSchemeRegistry = authSchemeRegistry;
        this.cookieStore = cookieStore;
        this.credentialsProvider = credentialsProvider;
        this.defaultConfig = defaultConfig;
    }

    private void setupContext(HttpClientContext context) {
        if (context.getAttribute("http.auth.target-scope") == null) {
            context.setAttribute("http.auth.target-scope", new AuthState());
        }
        if (context.getAttribute("http.auth.proxy-scope") == null) {
            context.setAttribute("http.auth.proxy-scope", new AuthState());
        }
        if (context.getAttribute("http.authscheme-registry") == null) {
            context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        }
        if (context.getAttribute("http.cookiespec-registry") == null) {
            context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        }
        if (context.getAttribute("http.cookie-store") == null) {
            context.setAttribute("http.cookie-store", this.cookieStore);
        }
        if (context.getAttribute("http.auth.credentials-provider") == null) {
            context.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        }
        if (context.getAttribute("http.request-config") == null) {
            context.setAttribute("http.request-config", this.defaultConfig);
        }
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        this.ensureRunning();
        BasicFuture<T> future = new BasicFuture<T>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        this.setupContext(localcontext);
        DefaultClientExchangeHandlerImpl<T> handler = new DefaultClientExchangeHandlerImpl<T>(this.log, requestProducer, responseConsumer, localcontext, future, this.connmgr, this.connReuseStrategy, this.keepaliveStrategy, this.exec);
        try {
            handler.start();
        }
        catch (Exception ex) {
            handler.failed(ex);
        }
        return future;
    }

    @Override
    public <T> Future<List<T>> execute(HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, HttpContext context, FutureCallback<List<T>> callback) {
        throw new UnsupportedOperationException("Pipelining not supported");
    }
}

