/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.nio.codecs;

import org.apache.http.shade.HttpException;
import org.apache.http.shade.HttpRequest;
import org.apache.http.shade.HttpRequestFactory;
import org.apache.http.shade.ParseException;
import org.apache.http.shade.RequestLine;
import org.apache.http.shade.annotation.NotThreadSafe;
import org.apache.http.shade.config.MessageConstraints;
import org.apache.http.shade.impl.DefaultHttpRequestFactory;
import org.apache.http.shade.impl.nio.codecs.AbstractMessageParser;
import org.apache.http.shade.message.LineParser;
import org.apache.http.shade.message.ParserCursor;
import org.apache.http.shade.nio.reactor.SessionInputBuffer;
import org.apache.http.shade.params.HttpParams;
import org.apache.http.shade.util.Args;
import org.apache.http.shade.util.CharArrayBuffer;

@NotThreadSafe
public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;

    @Deprecated
    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser parser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, parser, params);
        Args.notNull(requestFactory, "Request factory");
        this.requestFactory = requestFactory;
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser parser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(buffer, parser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer) {
        this(buffer, null);
    }

    @Override
    protected HttpRequest createMessage(CharArrayBuffer buffer) throws HttpException, ParseException {
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        RequestLine requestLine = this.lineParser.parseRequestLine(buffer, cursor);
        return this.requestFactory.newHttpRequest(requestLine);
    }
}

