/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.nio.codecs;

import org.apache.http.shade.HttpRequest;
import org.apache.http.shade.HttpRequestFactory;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.config.MessageConstraints;
import org.apache.http.shade.impl.DefaultHttpRequestFactory;
import org.apache.http.shade.impl.nio.codecs.DefaultHttpRequestParser;
import org.apache.http.shade.message.BasicLineParser;
import org.apache.http.shade.message.LineParser;
import org.apache.http.shade.nio.NHttpMessageParser;
import org.apache.http.shade.nio.NHttpMessageParserFactory;
import org.apache.http.shade.nio.reactor.SessionInputBuffer;

@Immutable
public class DefaultHttpRequestParserFactory
implements NHttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

