/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.nio.conn;

import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.http.shade.Header;
import org.apache.http.shade.HttpRequest;
import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.config.MessageConstraints;
import org.apache.http.shade.entity.ContentLengthStrategy;
import org.apache.http.shade.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.shade.impl.nio.conn.LoggingIOSession;
import org.apache.http.shade.nio.NHttpMessageParserFactory;
import org.apache.http.shade.nio.NHttpMessageWriterFactory;
import org.apache.http.shade.nio.conn.ManagedNHttpClientConnection;
import org.apache.http.shade.nio.reactor.IOSession;
import org.apache.http.shade.nio.reactor.ssl.SSLIOSession;
import org.apache.http.shade.nio.util.ByteBufferAllocator;
import org.apache.http.shade.util.Args;
import org.apache.http.shade.util.Asserts;

class ManagedNHttpClientConnectionImpl
extends DefaultNHttpClientConnection
implements ManagedNHttpClientConnection {
    private final Log headerlog;
    private final Log wirelog;
    private final Log log;
    private final String id;
    private IOSession original;

    public ManagedNHttpClientConnectionImpl(String id, Log log, Log headerlog, Log wirelog, IOSession iosession, int buffersize, int fragmentSizeHint, ByteBufferAllocator allocator, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, NHttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(iosession, buffersize, fragmentSizeHint, allocator, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        this.id = id;
        this.log = log;
        this.headerlog = headerlog;
        this.wirelog = wirelog;
        this.original = iosession;
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            super.bind(new LoggingIOSession(iosession, this.id, this.log, this.wirelog));
        }
    }

    @Override
    public void bind(IOSession iosession) {
        Args.notNull(iosession, "I/O session");
        Asserts.check(!iosession.isClosed(), "I/O session is closed");
        this.status = 0;
        this.original = iosession;
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " Upgrade session " + iosession));
            super.bind(new LoggingIOSession(iosession, this.id, this.log, this.wirelog));
        } else {
            super.bind(iosession);
        }
    }

    @Override
    public IOSession getIOSession() {
        return this.original;
    }

    @Override
    public SSLSession getSSLSession() {
        if (this.original instanceof SSLIOSession) {
            return ((SSLIOSession)this.original).getSSLSession();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    protected void onResponseReceived(HttpResponse response) {
        if (response != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug((Object)(this.id + " << " + response.getStatusLine().toString()));
            for (Header header : headers = response.getAllHeaders()) {
                this.headerlog.debug((Object)(this.id + " << " + header.toString()));
            }
        }
    }

    @Override
    protected void onRequestSubmitted(HttpRequest request) {
        if (request != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug((Object)(this.id + " >> " + request.getRequestLine().toString()));
            for (Header header : headers = request.getAllHeaders()) {
                this.headerlog.debug((Object)(this.id + " >> " + header.toString()));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.id);
        buf.append(" [");
        switch (this.status) {
            case 0: {
                buf.append("ACTIVE");
                if (!this.inbuf.hasData()) break;
                buf.append("(").append(this.inbuf.length()).append(")");
                break;
            }
            case 1: {
                buf.append("CLOSING");
                break;
            }
            case 2: {
                buf.append("CLOSED");
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

