/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.nio.entity;

import org.apache.http.shade.Header;
import org.apache.http.shade.HttpEntity;
import org.apache.http.shade.annotation.NotThreadSafe;
import org.apache.http.shade.entity.BasicHttpEntity;
import org.apache.http.shade.nio.entity.ContentInputStream;
import org.apache.http.shade.nio.util.ContentInputBuffer;
import org.apache.http.shade.util.Args;

@NotThreadSafe
public class ContentBufferEntity
extends BasicHttpEntity {
    private final HttpEntity wrappedEntity;

    public ContentBufferEntity(HttpEntity entity, ContentInputBuffer buffer) {
        Args.notNull(entity, "HTTP entity");
        this.wrappedEntity = entity;
        this.setContent(new ContentInputStream(buffer));
    }

    @Override
    public boolean isChunked() {
        return this.wrappedEntity.isChunked();
    }

    @Override
    public long getContentLength() {
        return this.wrappedEntity.getContentLength();
    }

    @Override
    public Header getContentType() {
        return this.wrappedEntity.getContentType();
    }

    @Override
    public Header getContentEncoding() {
        return this.wrappedEntity.getContentEncoding();
    }
}

