/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.nio.protocol;

import java.io.IOException;
import org.apache.http.shade.ContentTooLongException;
import org.apache.http.shade.HttpEntity;
import org.apache.http.shade.HttpEntityEnclosingRequest;
import org.apache.http.shade.HttpRequest;
import org.apache.http.shade.entity.ContentType;
import org.apache.http.shade.nio.ContentDecoder;
import org.apache.http.shade.nio.IOControl;
import org.apache.http.shade.nio.entity.ContentBufferEntity;
import org.apache.http.shade.nio.protocol.AbstractAsyncRequestConsumer;
import org.apache.http.shade.nio.util.HeapByteBufferAllocator;
import org.apache.http.shade.nio.util.SimpleInputBuffer;
import org.apache.http.shade.protocol.HttpContext;
import org.apache.http.shade.util.Asserts;

public class BasicAsyncRequestConsumer
extends AbstractAsyncRequestConsumer<HttpRequest> {
    private volatile HttpRequest request;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onRequestReceived(HttpRequest request) throws IOException {
        this.request = request;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        ((HttpEntityEnclosingRequest)this.request).setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.request = null;
        this.buf = null;
    }

    @Override
    protected HttpRequest buildResult(HttpContext context) {
        return this.request;
    }
}

