/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.3.7.1.internal.connectivity;

import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;

public class ConnectivityTestingErrorHandler {
    public static DefaultResult buildFailureTestResult(Exception exception) {
        ConnectionExceptionCode code;
        FailureType failureType = FailureType.UNSPECIFIED;
        if (exception instanceof ConnectionException && (code = ((ConnectionException)exception).getCode()) != null) {
            switch (code) {
                case UNKNOWN_HOST: {
                    failureType = FailureType.UNKNOWN_HOST;
                    break;
                }
                case CANNOT_REACH: {
                    failureType = FailureType.RESOURCE_UNAVAILABLE;
                    break;
                }
                case INCORRECT_CREDENTIALS: {
                    failureType = FailureType.INVALID_CREDENTIALS;
                    break;
                }
                case CREDENTIALS_EXPIRED: {
                    failureType = FailureType.INVALID_CREDENTIALS;
                    break;
                }
                default: {
                    failureType = FailureType.UNSPECIFIED;
                }
            }
        }
        return new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), failureType, (Throwable)exception);
    }
}

