/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.document.reader;

import com.google.common.base.Optional;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.modus.activity.document.reader.DocumentEnvelope;
import com.modus.activity.document.reader.DocumentReader;
import com.modus.activity.document.reader.DocumentReaderDocumentProperty;
import com.modus.activity.document.shredder.Message;
import com.modus.tpm.api.model.DocumentDefinition;
import com.modus.tpm.api.model.DocumentPropertyDefinition;
import com.modus.tpm.api.model.Partnership;
import com.modus.tpm.client.NotFoundTpmClientException;
import com.modus.tpm.client.TpmClient;
import com.modus.tracker.api.model.BusinessDocument;
import com.modus.tracker.api.model.DocumentProperty;
import com.modus.tracker.api.model.Error;
import com.modus.tracker.api.model.Metadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentReader<T extends Message>
implements DocumentReader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDocumentReader.class);
    private final TpmClient tpmClient;

    public AbstractDocumentReader(TpmClient tpmClient) {
        this.tpmClient = tpmClient;
    }

    @Override
    public List<BusinessDocument> read(DocumentEnvelope documentEnvelope) throws Exception {
        ArrayList<BusinessDocument> businessDocuments = new ArrayList<BusinessDocument>();
        List<T> messages = this.shred(documentEnvelope);
        for (Message message : messages) {
            Partnership partnership;
            try {
                String fromPartyIdentifier = this.getFromPartyIdentifier(documentEnvelope, message);
                String toPartyIdentifier = this.getToPartyIdentifier(documentEnvelope, message);
                partnership = fromPartyIdentifier == null && toPartyIdentifier == null ? this.tpmClient.getPartnership("00000000-0000-0000-0000-000000000000") : this.tpmClient.getPartnershipByIdentifiers(this.getFromPartyIdentifier(documentEnvelope, message), this.getToPartyIdentifier(documentEnvelope, message));
            }
            catch (NotFoundTpmClientException e) {
                partnership = this.tpmClient.getPartnership("00000000-0000-0000-0000-000000000000");
            }
            List<DocumentProperty> documentProperties = new ArrayList<DocumentProperty>();
            Optional<DocumentDefinition> documentDefinitionOptional = this.fetchDocumentDefinition(this.tpmClient, partnership.getId(), documentEnvelope, message);
            if (documentDefinitionOptional.isPresent()) {
                DocumentDefinition documentDefinition = (DocumentDefinition)documentDefinitionOptional.get();
                List documentPropertyDefinitions = documentDefinition.getPropertyDefinitions();
                documentProperties = this.readDocumentProperties(message, documentPropertyDefinitions);
            }
            BusinessDocument businessDocument = this.createBusinessDocument(documentEnvelope, documentDefinitionOptional, documentProperties, partnership, message);
            businessDocuments.add(businessDocument);
        }
        return businessDocuments;
    }

    protected Optional<DocumentDefinition> fetchDocumentDefinition(TpmClient tpmClient, String partnershipId, DocumentEnvelope documentEnvelope, Message message) throws Exception {
        try {
            return Optional.of((Object)tpmClient.resolveDocumentDefinition(partnershipId, documentEnvelope.getFormat().toUpperCase(), message.getVersion(), (String)message.getType().or((Object)"")));
        }
        catch (NotFoundTpmClientException e) {
            logger.debug(String.format("No document definition found for %s document with version %s and message type %s in partnership %s", documentEnvelope.getFormat(), message.getVersion(), message.getType().or((Object)""), partnershipId));
            return Optional.absent();
        }
    }

    protected List<DocumentProperty> readDocumentProperties(T message, List<DocumentPropertyDefinition> documentPropertyDefinitions) throws Exception {
        ArrayList<DocumentProperty> documentProperties = new ArrayList<DocumentProperty>();
        DocumentContext contentDocumentContext = JsonPath.parse((Object)((Message)message).getFragment().or(new HashMap()), (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}).addOptions(new Option[]{Option.ALWAYS_RETURN_LIST}));
        for (DocumentPropertyDefinition documentPropertyDefinition : documentPropertyDefinitions) {
            if (!documentPropertyDefinition.getSource().equals((Object)DocumentPropertyDefinition.Source.DOCUMENT)) continue;
            List results = (List)contentDocumentContext.read(documentPropertyDefinition.getExpression(), new Predicate[0]);
            if (logger.isDebugEnabled() && results.isEmpty()) {
                logger.debug("Could not read property {} from expression {} in the following document fragment: {} ", new Object[]{documentPropertyDefinition.getName(), documentPropertyDefinition.getExpression(), contentDocumentContext.json().toString()});
            }
            for (Object result : results) {
                DocumentReaderDocumentProperty documentProperty = new DocumentReaderDocumentProperty();
                documentProperty.setDocumentPropertyTypeId(documentPropertyDefinition.getPropertyTypeId());
                documentProperty.setDocumentPropertyDefinitionId(documentPropertyDefinition.getId());
                documentProperty.setDocumentPropertyName(documentPropertyDefinition.getName());
                documentProperty.setDocumentPropertyValue(result.toString());
                documentProperty.setDocumentPropertyTypeName(documentPropertyDefinition.getPropertyTypeName());
                documentProperties.add(documentProperty);
            }
        }
        return documentProperties;
    }

    protected abstract List<T> shred(DocumentEnvelope var1) throws Exception;

    protected abstract String getErrors(DocumentEnvelope var1) throws Exception;

    protected String getFromPartyIdentifier(DocumentEnvelope documentEnvelope, T message) {
        if (documentEnvelope.getDirection().equals("INBOUND")) {
            return documentEnvelope.getPartnerIdentifier();
        }
        return null;
    }

    protected String getToPartyIdentifier(DocumentEnvelope documentEnvelope, T message) {
        if (documentEnvelope.getDirection().equals("OUTBOUND")) {
            return documentEnvelope.getPartnerIdentifier();
        }
        return null;
    }

    private BusinessDocument createBusinessDocument(DocumentEnvelope documentEnvelope, Optional<DocumentDefinition> documentDefinitionOptional, List<DocumentProperty> documentProperties, Partnership partnership, Message message) throws Exception {
        String errors;
        BusinessDocument businessDocument = new BusinessDocument();
        businessDocument.setDirection(BusinessDocument.Direction.valueOf((String)documentEnvelope.getDirection()));
        businessDocument.setFilename(documentEnvelope.getFilename());
        businessDocument.setFileUrl(documentEnvelope.getFileUrl() != null ? documentEnvelope.getFileUrl() : "");
        businessDocument.setFormatType(documentEnvelope.getFormat());
        businessDocument.setDocumentProperties(documentProperties);
        businessDocument.setPartnershipId(partnership.getId());
        businessDocument.setProcessedAt(documentEnvelope.getCreatedAt());
        businessDocument.setVersion(message.getVersion());
        businessDocument.setMessageType((String)message.getType().orNull());
        if (documentEnvelope.getMetadata() != null) {
            businessDocument.setMetadata(new Metadata());
            businessDocument.getMetadata().getAdditionalProperties().putAll(documentEnvelope.getMetadata());
        }
        if ((errors = this.getErrors(documentEnvelope)) != null) {
            Error error = new Error();
            error.setMessage("Document Processing Error");
            error.setCode(Integer.valueOf(6));
            error.setSource(Error.Source.DOCUMENT);
            error.setDetail(errors);
            businessDocument.setErrors(Arrays.asList(error));
        }
        if (documentDefinitionOptional.isPresent()) {
            businessDocument.setDocumentDefinitionId(((DocumentDefinition)documentDefinitionOptional.get()).getId().toString());
        }
        return businessDocument;
    }
}

