/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.document.reader.edifact;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.modus.activity.document.reader.AbstractDocumentReader;
import com.modus.activity.document.reader.DocumentEnvelope;
import com.modus.activity.document.shredder.edifact.EdifactDocumentShredder;
import com.modus.activity.document.shredder.edifact.EdifactMessage;
import com.modus.tpm.client.TpmClient;
import java.util.List;
import java.util.Map;

public class EdifactDocumentReader
extends AbstractDocumentReader<EdifactMessage> {
    private final EdifactDocumentShredder edifactDocumentShredder = new EdifactDocumentShredder();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public EdifactDocumentReader(TpmClient tpmClient) {
        super(tpmClient);
    }

    @Override
    protected List<EdifactMessage> shred(DocumentEnvelope documentEnvelope) {
        return this.edifactDocumentShredder.shred((Map)documentEnvelope.getContent());
    }

    @Override
    protected String getErrors(DocumentEnvelope documentEnvelope) throws Exception {
        List errors;
        String errorsSerialised = null;
        Map content = (Map)documentEnvelope.getContent();
        if (content.get("Errors") != null && (errors = (List)content.get("Errors")).size() > 0) {
            errorsSerialised = this.objectMapper.writeValueAsString((Object)errors);
        }
        return errorsSerialised;
    }

    @Override
    protected String getFromPartyIdentifier(DocumentEnvelope documentEnvelope, EdifactMessage message) {
        if (documentEnvelope.getPartnerIdentifier() != null) {
            if (documentEnvelope.getDirection().equals("INBOUND")) {
                return documentEnvelope.getPartnerIdentifier();
            }
            return null;
        }
        return message.getInterchangeSenderId();
    }

    @Override
    protected String getToPartyIdentifier(DocumentEnvelope documentEnvelope, EdifactMessage message) {
        if (documentEnvelope.getPartnerIdentifier() != null) {
            if (documentEnvelope.getDirection().equals("OUTBOUND")) {
                return documentEnvelope.getPartnerIdentifier();
            }
            return null;
        }
        return message.getInterchangeReceiverId();
    }
}

