/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.document.reader.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.modus.activity.document.reader.AbstractDocumentReader;
import com.modus.activity.document.reader.DocumentEnvelope;
import com.modus.activity.document.shredder.Message;
import com.modus.tpm.client.TpmClient;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JsonDocumentReader
extends AbstractDocumentReader<Message> {
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonDocumentReader(TpmClient tpmClient) {
        super(tpmClient);
    }

    @Override
    protected List<Message> shred(DocumentEnvelope documentEnvelope) throws Exception {
        Message message = new Message();
        message.setVersion(documentEnvelope.getVersion());
        message.setType((Optional<String>)Optional.fromNullable((Object)documentEnvelope.getMessageType()));
        String content = (String)documentEnvelope.getContent();
        if (documentEnvelope != null) {
            message.setFragment(Optional.fromNullable((Object)this.objectMapper.readValue(content, Map.class)));
        }
        return Arrays.asList(message);
    }

    @Override
    protected String getErrors(DocumentEnvelope documentEnvelope) throws Exception {
        return null;
    }
}

