/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.document.reader.x12;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.modus.activity.document.reader.AbstractDocumentReader;
import com.modus.activity.document.reader.DocumentEnvelope;
import com.modus.activity.document.shredder.x12.X12DocumentShredder;
import com.modus.activity.document.shredder.x12.X12Message;
import com.modus.tpm.client.TpmClient;
import java.util.List;
import java.util.Map;

public class X12DocumentReader
extends AbstractDocumentReader<X12Message> {
    private final X12DocumentShredder x12DocumentShredder = new X12DocumentShredder();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public X12DocumentReader(TpmClient tpmClient) {
        super(tpmClient);
    }

    @Override
    protected List<X12Message> shred(DocumentEnvelope documentEnvelope) {
        return this.x12DocumentShredder.shred((Map)documentEnvelope.getContent());
    }

    @Override
    protected String getErrors(DocumentEnvelope documentEnvelope) throws Exception {
        List errors;
        String errorsSerialised = null;
        Map content = (Map)documentEnvelope.getContent();
        if (content.get("Errors") != null && (errors = (List)content.get("Errors")).size() > 0) {
            errorsSerialised = this.objectMapper.writeValueAsString((Object)errors);
        }
        return errorsSerialised;
    }

    @Override
    protected String getFromPartyIdentifier(DocumentEnvelope documentEnvelope, X12Message message) {
        if (documentEnvelope.getPartnerIdentifier() != null) {
            if (documentEnvelope.getDirection().equals("INBOUND")) {
                return documentEnvelope.getPartnerIdentifier();
            }
            return null;
        }
        return message.getInterchangeSenderId();
    }

    @Override
    protected String getToPartyIdentifier(DocumentEnvelope documentEnvelope, X12Message message) {
        if (documentEnvelope.getPartnerIdentifier() != null) {
            if (documentEnvelope.getDirection().equals("OUTBOUND")) {
                return documentEnvelope.getPartnerIdentifier();
            }
            return null;
        }
        return message.getInterchangeReceiverId();
    }
}

