/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.document.reader.xml;

import com.google.common.base.Optional;
import com.modus.activity.document.reader.AbstractDocumentReader;
import com.modus.activity.document.reader.DocumentEnvelope;
import com.modus.activity.document.reader.DocumentReaderDocumentProperty;
import com.modus.activity.document.shredder.xml.XmlMessage;
import com.modus.tpm.api.model.DocumentPropertyDefinition;
import com.modus.tpm.client.TpmClient;
import com.modus.tracker.api.model.DocumentProperty;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlDocumentReader
extends AbstractDocumentReader<XmlMessage> {
    private final XPath xpath = XPathFactory.newInstance().newXPath();
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final DocumentBuilderFactory namespaceAwareDocumentBuilderFactory = DocumentBuilderFactory.newInstance();

    public XmlDocumentReader(TpmClient tpmClient) {
        super(tpmClient);
        this.namespaceAwareDocumentBuilderFactory.setNamespaceAware(true);
    }

    @Override
    protected List<XmlMessage> shred(DocumentEnvelope documentEnvelope) throws Exception {
        XmlMessage message = new XmlMessage();
        String messageType = documentEnvelope.getMessageType();
        String document = null;
        if (documentEnvelope.getContent() != null && documentEnvelope.getContent() instanceof String) {
            document = (String)documentEnvelope.getContent();
        } else if (documentEnvelope.getContent() != null && documentEnvelope.getContent() instanceof InputStream) {
            document = IOUtils.toString((InputStream)((InputStream)documentEnvelope.getContent()));
        }
        if (document != null) {
            DocumentBuilder documentBuilder = this.namespaceAwareDocumentBuilderFactory.newDocumentBuilder();
            Document documentNode = documentBuilder.parse(new ByteArrayInputStream(document.getBytes()));
            String namespaceURI = documentNode.getDocumentElement().getNamespaceURI() != null ? documentNode.getDocumentElement().getNamespaceURI() + ":" : null;
            String type = StringUtils.defaultString(namespaceURI, (String)"") + documentNode.getDocumentElement().getTagName();
            message.setFragment((Optional<String>)Optional.fromNullable((Object)document));
            if (messageType != null) {
                message.setType((Optional<String>)Optional.fromNullable((Object)messageType));
            } else {
                message.setType((Optional<String>)Optional.fromNullable((Object)type));
            }
        } else {
            message.setType((Optional<String>)Optional.fromNullable((Object)messageType));
        }
        return Arrays.asList(message);
    }

    @Override
    protected List<DocumentProperty> readDocumentProperties(XmlMessage message, List<DocumentPropertyDefinition> propertyDefinitions) throws Exception {
        ArrayList<DocumentProperty> documentProperties = new ArrayList<DocumentProperty>();
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        String documentString = (String)message.getFragment().or((Object)"");
        if (StringUtils.isNotBlank((CharSequence)documentString)) {
            Document document = documentBuilder.parse(new ByteArrayInputStream(documentString.getBytes()));
            for (DocumentPropertyDefinition documentPropertyDefinition : propertyDefinitions) {
                if (!documentPropertyDefinition.getSource().equals((Object)DocumentPropertyDefinition.Source.DOCUMENT)) continue;
                Node node = (Node)this.xpath.evaluate(documentPropertyDefinition.getExpression(), document, XPathConstants.NODE);
                DocumentReaderDocumentProperty documentProperty = new DocumentReaderDocumentProperty();
                documentProperty.setDocumentPropertyTypeId(documentPropertyDefinition.getPropertyTypeId());
                documentProperty.setDocumentPropertyDefinitionId(documentPropertyDefinition.getId());
                documentProperty.setDocumentPropertyName(documentPropertyDefinition.getName());
                documentProperty.setDocumentPropertyValue(node.getTextContent());
                documentProperty.setDocumentPropertyTypeName(documentPropertyDefinition.getPropertyTypeName());
                documentProperties.add(documentProperty);
            }
        }
        return documentProperties;
    }

    @Override
    protected String getErrors(DocumentEnvelope documentEnvelope) throws Exception {
        return null;
    }
}

