/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.document.shredder.x12;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.modus.activity.document.shredder.DocumentShredder;
import com.modus.activity.document.shredder.x12.X12Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class X12DocumentShredder
implements DocumentShredder<X12Message, Map<String, Serializable>> {
    @Override
    public List<X12Message> shred(Map<String, Serializable> document) {
        DocumentContext documentContext = JsonPath.parse(document, (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
        if (this.isFaultyDocument(documentContext)) {
            return this.splitFunctionalGeneratedAcks(documentContext);
        }
        return this.splitTransactionSets(document, documentContext);
    }

    private List<X12Message> splitTransactionSets(Map<String, Serializable> document, DocumentContext documentContext) {
        ArrayList<X12Message> messages = new ArrayList<X12Message>();
        Map transactionSetsByTransactionSetIdsAndVersions = (Map)documentContext.read("$.TransactionSets", new Predicate[0]);
        for (Map.Entry transactionSetsByTransactionSetIdsAndVersion : transactionSetsByTransactionSetIdsAndVersions.entrySet()) {
            for (Map.Entry transactionSetsByTransactionSetId : ((Map)transactionSetsByTransactionSetIdsAndVersion.getValue()).entrySet()) {
                for (Map transaction : (List)transactionSetsByTransactionSetId.getValue()) {
                    DocumentContext transactionDocumentContext = JsonPath.parse((Object)transaction, (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
                    String transactionSetId = (String)transactionDocumentContext.read("$.Id", new Predicate[0]);
                    String interchangeControlVersionNumber = (String)transactionDocumentContext.read("$.Interchange.ISA12", new Predicate[0]);
                    if (interchangeControlVersionNumber == null) {
                        interchangeControlVersionNumber = (String)documentContext.read("$.Interchange.ISA12", new Predicate[0]);
                    }
                    HashMap<String, Serializable> fragment = new HashMap<String, Serializable>();
                    for (Map.Entry<String, Serializable> entry : document.entrySet()) {
                        if (entry.getKey().equals("TransactionSets")) continue;
                        fragment.put(entry.getKey(), entry.getValue());
                    }
                    fragment.put("TransactionSets", (Serializable)ImmutableMap.of(transactionSetsByTransactionSetIdsAndVersion.getKey(), (Object)ImmutableMap.of(transactionSetsByTransactionSetId.getKey(), Arrays.asList(transaction))));
                    X12Message x12Message = new X12Message();
                    x12Message.setType((Optional<String>)Optional.fromNullable((Object)transactionSetId));
                    x12Message.setVersion(interchangeControlVersionNumber);
                    x12Message.setFragment((Optional<Map>)Optional.fromNullable(fragment));
                    this.setIdentifier(x12Message, transactionDocumentContext, false);
                    messages.add(x12Message);
                }
            }
        }
        return messages;
    }

    private List<X12Message> splitFunctionalGeneratedAcks(DocumentContext documentContext) {
        Map faultyDocument;
        ArrayList<X12Message> messages = new ArrayList<X12Message>();
        List generatedFunctionalAcks = (List)documentContext.read("$.FunctionalAcksGenerated.*", new Predicate[0]);
        for (Map generatedFunctionalAck : generatedFunctionalAcks) {
            DocumentContext generatedFunctionalAckDocumentContext = JsonPath.parse((Object)generatedFunctionalAck, (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
            String interchangeControlVersionNumber = (String)generatedFunctionalAckDocumentContext.read("$.Interchange.ISA12", new Predicate[0]);
            X12Message x12Message = new X12Message();
            x12Message.setVersion(interchangeControlVersionNumber);
            this.setIdentifier(x12Message, generatedFunctionalAckDocumentContext, true);
            messages.add(x12Message);
        }
        if (generatedFunctionalAcks.isEmpty() && !(faultyDocument = (Map)documentContext.read("$", new Predicate[0])).isEmpty()) {
            DocumentContext faultyDocumentDocumentContext = JsonPath.parse((Object)faultyDocument, (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
            X12Message x12Message = new X12Message();
            x12Message.setVersion((String)faultyDocumentDocumentContext.read("$.ISA12", new Predicate[0]));
            x12Message.setFragment((Optional<Map>)Optional.of((Object)faultyDocument));
            x12Message.setInterchangeSenderId((String)faultyDocumentDocumentContext.read("$.ISA06", new Predicate[0]));
            x12Message.setInterchangeSenderQualifierId((String)faultyDocumentDocumentContext.read("$.ISA05", new Predicate[0]));
            x12Message.setInterchangeReceiverId((String)faultyDocumentDocumentContext.read("$.ISA08", new Predicate[0]));
            x12Message.setInterchangeReceiverQualifierId((String)faultyDocumentDocumentContext.read("$.ISA07", new Predicate[0]));
            x12Message.setInterchangeControlNumber(String.valueOf(faultyDocumentDocumentContext.read("$.ISA13", new Predicate[0])));
            messages.add(x12Message);
        }
        return messages;
    }

    private boolean isFaultyDocument(DocumentContext documentContext) {
        List transactionSets = (List)documentContext.read("$.TransactionSets.*.*.*", new Predicate[0]);
        return transactionSets.isEmpty();
    }

    private void setIdentifier(X12Message x12Message, DocumentContext documentContext, boolean isFaulty) {
        if (isFaulty) {
            x12Message.setInterchangeReceiverId((String)documentContext.read("$.Interchange.ISA06", new Predicate[0]));
            x12Message.setInterchangeReceiverQualifierId((String)documentContext.read("$.Interchange.ISA05", new Predicate[0]));
            x12Message.setApplicationReceiverCode((String)documentContext.read("$.Group.GS02", new Predicate[0]));
            x12Message.setInterchangeSenderId((String)documentContext.read("$.Interchange.ISA08", new Predicate[0]));
            x12Message.setInterchangeSenderQualifierId((String)documentContext.read("$.Interchange.ISA07", new Predicate[0]));
            x12Message.setApplicationSenderCode((String)documentContext.read("$.Group.GS03", new Predicate[0]));
        } else {
            x12Message.setInterchangeSenderId((String)documentContext.read("$.Interchange.ISA06", new Predicate[0]));
            x12Message.setInterchangeSenderQualifierId((String)documentContext.read("$.Interchange.ISA05", new Predicate[0]));
            x12Message.setApplicationSenderCode((String)documentContext.read("$.Group.GS02", new Predicate[0]));
            x12Message.setInterchangeReceiverId((String)documentContext.read("$.Interchange.ISA08", new Predicate[0]));
            x12Message.setInterchangeReceiverQualifierId((String)documentContext.read("$.Interchange.ISA07", new Predicate[0]));
            x12Message.setApplicationReceiverCode((String)documentContext.read("$.Group.GS03", new Predicate[0]));
        }
        Integer interchangeControlNumber = (Integer)documentContext.read("$.Interchange.ISA13", new Predicate[0]);
        Integer functionalGroupControlNumber = (Integer)documentContext.read("$.Group.GS06", new Predicate[0]);
        if (interchangeControlNumber != null) {
            x12Message.setInterchangeControlNumber(interchangeControlNumber.toString());
        }
        if (functionalGroupControlNumber != null) {
            x12Message.setFunctionalGroupControlNumber(functionalGroupControlNumber.toString());
        }
    }
}

