/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.payload;

import com.modus.activity.payload.PayloadHttpClients;
import com.modus.util.Aws4SignerBase;
import com.modus.util.Aws4SignerForAuthorizationHeader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.client.HttpClient;
import org.apache.http.shade.pmc.client.methods.CloseableHttpResponse;
import org.apache.http.shade.pmc.client.methods.HttpGet;
import org.apache.http.shade.pmc.impl.client.CloseableHttpClient;
import org.springframework.stereotype.Component;

@Component
public class S3BlobHandler {
    @Inject
    PayloadHttpClients payloadHttpClients;

    public HttpResponse getResponse(S3BlobDescription s3BlobDescription) {
        try {
            URL endpointUrl;
            HttpClient httpClient = this.payloadHttpClients.getHttpClient();
            String url = s3BlobDescription.region.equals("us-east-1") ? "https://s3.amazonaws.com/" + s3BlobDescription.bucket + "/" + s3BlobDescription.location : "https://s3-" + s3BlobDescription.region + ".amazonaws.com/" + s3BlobDescription.bucket + "/" + s3BlobDescription.location;
            try {
                endpointUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to parse service endpoint: " + e.getMessage());
            }
            byte[] contentHash = Aws4SignerBase.hash("");
            String contentHashString = Aws4SignerBase.toHex(contentHash);
            HashMap<String, String> headers = new HashMap<String, String>();
            Aws4SignerForAuthorizationHeader signer = new Aws4SignerForAuthorizationHeader(endpointUrl, "GET", "s3", s3BlobDescription.region);
            String authorization = signer.computeSignature(headers, null, contentHashString, s3BlobDescription.accessKeyId, s3BlobDescription.securityKey);
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", authorization);
            httpGet.setHeader("x-amz-content-sha256", contentHashString);
            httpGet.setHeader("x-amz-date", (String)headers.get("x-amz-date"));
            CloseableHttpResponse httpResponse = ((CloseableHttpClient)httpClient).execute(httpGet);
            return httpResponse;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static class S3BlobDescription {
        String accessKeyId;
        String securityKey;
        String bucket;
        String location;
        String region;
    }
}

