/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.payload;

import com.modus.activity.payload.S3BlobHandler;
import com.modus.activity.payload.SecurityContext;
import java.net.URL;
import javax.inject.Inject;
import org.apache.http.shade.pmc.HttpResponse;
import org.springframework.stereotype.Component;

@Component
class S3SecurityContext
extends SecurityContext {
    @Inject
    S3BlobHandler s3BlobHandler;

    @Override
    public HttpResponse getPayloadResponse(final URL payloadLocation) {
        final String[] pathComponents = payloadLocation.getPath().split("/");
        return this.s3BlobHandler.getResponse(new S3BlobHandler.S3BlobDescription(){
            {
                this.accessKeyId = (String)S3SecurityContext.this.parameters.get("accessKeyId");
                this.securityKey = (String)S3SecurityContext.this.parameters.get("securityKey");
                this.bucket = pathComponents[1];
                this.location = S3SecurityContext.this.assemble(pathComponents);
                String[] regions = payloadLocation.getHost().split("\\.")[0].split("s3");
                this.region = regions.length == 0 ? "us-east-1" : regions[1].substring(1);
            }
        });
    }

    private String assemble(String[] pathComponents) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 2; i < pathComponents.length; ++i) {
            if (i > 2) {
                buffer.append("/");
            }
            buffer.append(pathComponents[i]);
        }
        return buffer.toString();
    }
}

