/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.payload;

import com.modus.activity.payload.SecurityContextAuthenticationException;
import com.modus.activity.payload.SecurityContextUnknownException;
import com.modus.tpm.client.TpmClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.http.shade.pmc.HttpResponse;
import org.springframework.stereotype.Component;

@Component
public abstract class SecurityContext {
    Map<String, Object> parameters;

    public InputStream getPayloadData(URL payloadLocation) {
        try {
            HttpResponse httpResponse = this.getPayloadResponse(payloadLocation);
            int status = httpResponse.getStatusLine().getStatusCode();
            InputStream content = httpResponse.getEntity().getContent();
            if (status >= 401 && status < 500) {
                throw new SecurityContextAuthenticationException(content);
            }
            if (status >= 300 || status < 200) {
                throw new SecurityContextUnknownException(content);
            }
            return content;
        }
        catch (IOException t) {
            throw new RuntimeException(t);
        }
    }

    public abstract HttpResponse getPayloadResponse(URL var1);

    public void setConfigParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void initialize(TpmClient tpmClient) {
    }
}

