/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm;

import com.modus.mule.modules.apm.ConnectorContext;
import com.modus.mule.modules.apm.ExponentialBackOff;
import com.modus.tracker.api.model.BusinessDocument;
import com.modus.tracker.api.model.Transmission;
import com.modus.tracker.client.TrackerClientException;
import com.modus.tracker.client.UnRetryableException;
import com.modus.tracker.model.TransactionCreate;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.api.MuleEvent;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;
import org.mule.util.xa.ResourceManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTransactionSynchronizer {
    public static final String QUEUE_NAME = "_partnerManagerConnectorTransactionQueue";
    private static final Logger logger = LoggerFactory.getLogger(AsyncTransactionSynchronizer.class);
    private static ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final Synchronizer synchronizer;
    private ScheduledFuture<?> scheduledFuture;

    public AsyncTransactionSynchronizer(ConnectorContext connectorContext, TaskQueue taskQueue) {
        this.synchronizer = new Synchronizer(connectorContext, taskQueue);
    }

    public void startSynchronizing() {
        this.scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(this.synchronizer, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public void stopSynchronizing() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
    }

    public static class TaskQueue {
        private final QueueManager queueManager;

        public TaskQueue(QueueManager queueManager) {
            this.queueManager = queueManager;
        }

        public void put(Task task) throws ObjectStoreException, InterruptedException {
            this.queueManager.getQueueSession().getQueue(AsyncTransactionSynchronizer.QUEUE_NAME).put((Serializable)task);
        }

        public int size() {
            return this.queueManager.getQueueSession().getQueue(AsyncTransactionSynchronizer.QUEUE_NAME).size();
        }

        public QueueSession getQueueSession() throws ResourceManagerException {
            return this.queueManager.getQueueSession();
        }
    }

    public static class EvaluateTransactionReleaseStatusTask
    extends Task {
        private String routeId;
        private String routeStatus;
        private String transactionId;

        public EvaluateTransactionReleaseStatusTask() {
            this.name = "evaluate transaction release status";
        }

        public String getRouteId() {
            return this.routeId;
        }

        public EvaluateTransactionReleaseStatusTask setRouteId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public String getRouteStatus() {
            return this.routeStatus;
        }

        public EvaluateTransactionReleaseStatusTask setRouteStatus(String routeStatus) {
            this.routeStatus = routeStatus;
            return this;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public EvaluateTransactionReleaseStatusTask setTransactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }
    }

    public static class CreateTransactionTask
    extends Task {
        private TransactionCreate transaction;
        private Serializable file;
        private MuleEvent muleEvent;

        public CreateTransactionTask() {
            this.name = "create transaction";
        }

        public TransactionCreate getTransaction() {
            return this.transaction;
        }

        public CreateTransactionTask setTransaction(TransactionCreate transaction) {
            this.transaction = transaction;
            return this;
        }

        public Serializable getFile() {
            return this.file;
        }

        public CreateTransactionTask setFile(Serializable file) {
            this.file = file;
            return this;
        }

        public MuleEvent getMuleEvent() {
            return this.muleEvent;
        }

        public CreateTransactionTask setMuleEvent(MuleEvent muleEvent) {
            this.muleEvent = muleEvent;
            return this;
        }
    }

    private static class Task
    implements Serializable {
        protected String name;
        private ExponentialBackOff.ExponentialBackOffExecution backOffExecution;
        private Long nextBackOff = 0L;
        private Long processedAt = System.currentTimeMillis();

        public Task() {
            ExponentialBackOff exponentialBackOff = new ExponentialBackOff(1000L, 2.0);
            exponentialBackOff.setMaxInterval(1800000L);
            this.backOffExecution = exponentialBackOff.start();
        }

        public long getCurrentBackOff() {
            return this.nextBackOff;
        }

        public long nextBackOff() {
            this.nextBackOff = this.backOffExecution.nextBackOff();
            return this.nextBackOff;
        }

        public Long getProcessedAt() {
            return this.processedAt;
        }

        public void setProcessedAt(Long processedAt) {
            this.processedAt = processedAt;
        }

        public String getName() {
            return this.name;
        }
    }

    private class Synchronizer
    implements Runnable {
        private final TaskQueue taskQueue;
        private final ConnectorContext connectorContext;

        public Synchronizer(ConnectorContext connectorContext, TaskQueue taskQueue) {
            this.taskQueue = taskQueue;
            this.connectorContext = connectorContext;
        }

        @Override
        public void run() {
            while (this.taskQueue.size() > 0) {
                Task task = null;
                Queue queue = null;
                QueueSession queueSession = null;
                try {
                    queueSession = this.taskQueue.getQueueSession();
                    queueSession.begin();
                    queue = queueSession.getQueue(AsyncTransactionSynchronizer.QUEUE_NAME);
                    task = (Task)queue.take();
                    this.processTask(task, queue);
                    queueSession.commit();
                }
                catch (Throwable t) {
                    this.requeueTask(queueSession, queue, task, t);
                }
            }
        }

        private void processTask(Task task, Queue queue) throws Exception {
            if (System.currentTimeMillis() - task.getProcessedAt() >= task.getCurrentBackOff()) {
                if (task instanceof CreateTransactionTask) {
                    CreateTransactionTask createTransactionTask = (CreateTransactionTask)task;
                    String fileUrl = this.connectorContext.getFileStorageProvider().store(createTransactionTask.getMuleEvent(), createTransactionTask.getFile());
                    for (BusinessDocument businessDocument : createTransactionTask.getTransaction().getBusinessDocuments()) {
                        businessDocument.setFileUrl(fileUrl);
                    }
                    for (Transmission transmission : createTransactionTask.getTransaction().getTransmissions()) {
                        transmission.setFileUrl(fileUrl);
                    }
                    this.createTransaction(createTransactionTask);
                } else if (task instanceof EvaluateTransactionReleaseStatusTask) {
                    EvaluateTransactionReleaseStatusTask evaluateTransactionReleaseStatusTask = (EvaluateTransactionReleaseStatusTask)task;
                    this.connectorContext.getTrackerClient().evaluateTransactionReleaseStatus(evaluateTransactionReleaseStatusTask.getTransactionId(), evaluateTransactionReleaseStatusTask.getRouteId(), evaluateTransactionReleaseStatusTask.getRouteStatus());
                }
            } else {
                queue.put((Serializable)task);
            }
        }

        private void requeueTask(QueueSession queueSession, Queue queue, Task task, Throwable t) {
            if (queueSession != null) {
                if (task != null && queue != null) {
                    task.setProcessedAt(System.currentTimeMillis());
                    long nextBackOff = TimeUnit.MILLISECONDS.toSeconds(task.nextBackOff());
                    try {
                        logger.warn(String.format("Failed to %s. Retrying in %s seconds", task.getName(), nextBackOff), t);
                        queue.put((Serializable)task);
                        queueSession.commit();
                    }
                    catch (Exception e) {
                        logger.error(String.format("Error occurred while requeuing %s operation for later retry.", task.getName()), (Throwable)e);
                        this.rollback(queueSession);
                    }
                } else {
                    logger.error("Failed to read operation from queue", t);
                    this.rollback(queueSession);
                }
            } else {
                logger.error("Failed to began resource transaction", t);
            }
        }

        private void rollback(QueueSession queueSession) {
            try {
                queueSession.rollback();
            }
            catch (ResourceManagerException rme) {
                logger.error("Failed to rollback resource transaction", (Throwable)rme);
            }
        }

        private void createTransaction(CreateTransactionTask task) throws TrackerClientException {
            try {
                this.connectorContext.getTrackerClient().createTransaction(task.getTransaction());
                logger.info(String.format("Created transaction %s", task.getTransaction().getId()));
            }
            catch (UnRetryableException e) {
                logger.error(String.format("Failed to create transaction %s. Dropping un-retryable transaction", task.getTransaction().getId()), (Throwable)e);
            }
        }
    }
}

