/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.modus.activity.document.reader.DocumentReaderDocumentProperty;
import com.modus.mule.modules.apm.PartnerManagerConnectorException;
import com.modus.tpm.api.model.Entry;
import com.modus.tpm.client.TpmClient;
import com.modus.tpm.client.TpmClientException;
import com.modus.tracker.api.model.BusinessDocument;
import com.modus.tracker.api.model.DocumentProperty;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java8.util.Optional;
import java8.util.function.Predicate;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import java8.util.stream.StreamSupport;
import org.apache.commons.collections.MapUtils;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.MessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyReader {
    private static final Logger logger = LoggerFactory.getLogger(PropertyReader.class);
    private static final String SINGLE_FIELD_CAPTURE_TYPE = "SINGLE_FIELD";
    private final TpmClient tpmClient;

    public PropertyReader(TpmClient tpmClient) {
        this.tpmClient = tpmClient;
    }

    public void readAndLoadDocumentProperties(BusinessDocument businessDocument, TransmissionSession transmissionSession, MuleEvent muleEvent) throws Exception {
        Map properties = (Map)transmissionSession.get((Object)"properties");
        for (DocumentProperty documentProperty : businessDocument.getDocumentProperties()) {
            if (!(documentProperty instanceof DocumentReaderDocumentProperty)) continue;
            properties.put(((DocumentReaderDocumentProperty)documentProperty).getDocumentPropertyTypeName(), documentProperty.getDocumentPropertyValue());
        }
        if (businessDocument.getDocumentDefinitionId() != null) {
            String propertyValue;
            List<Map<String, Serializable>> documentDefinitions = this.tpmClient.search(TpmClient.Resource.DOCUMENT_DEFINITION, String.format("id == %s", businessDocument.getDocumentDefinitionId()), null, null, null, null);
            if (documentDefinitions.isEmpty()) {
                throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)("No document definition found with ID " + businessDocument.getDocumentDefinitionId())));
            }
            Map<String, Serializable> documentDefinition = documentDefinitions.get(0);
            List propertyDefinitions = (List)((Object)documentDefinition.get("propertyDefinitions"));
            for (Map map : propertyDefinitions) {
                if (!map.get("documentDefinitionId").equals(businessDocument.getDocumentDefinitionId()) || (propertyValue = this.readProperty((String)map.get("source"), (String)map.get("expression"), muleEvent)) == null) continue;
                properties.put((String)map.get("propertyTypeName"), propertyValue);
                this.attachPropertyToBusinessDocument(businessDocument, map, propertyValue);
            }
            for (Map map : this.selectLookupPropertyDefinitions(propertyDefinitions)) {
                if (!map.get("documentDefinitionId").equals(businessDocument.getDocumentDefinitionId()) || (propertyValue = this.readLookupProperty((String)map.get("expression"), properties, muleEvent)) == null) continue;
                properties.put((String)map.get("propertyTypeName"), propertyValue);
                this.attachPropertyToBusinessDocument(businessDocument, map, propertyValue);
            }
        }
    }

    private void attachPropertyToBusinessDocument(BusinessDocument businessDocument, Map<String, Object> propertyDefinition, String propertyValue) {
        DocumentProperty newProperty = new DocumentProperty();
        newProperty.setDocumentPropertyDefinitionId((String)propertyDefinition.get("id"));
        newProperty.setDocumentPropertyName((String)propertyDefinition.get("name"));
        newProperty.setDocumentPropertyTypeId((String)propertyDefinition.get("propertyTypeId"));
        newProperty.setDocumentPropertyValue(propertyValue);
        businessDocument.getDocumentProperties().add(newProperty);
    }

    private List<Map<String, Object>> selectLookupPropertyDefinitions(List<Map<String, Object>> propertyDefinitions) {
        Comparator<Map<String, Object>> comparator = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(final Map<String, Object> pf1, Map<String, Object> pf2) {
                Optional found;
                try {
                    List pf2Fields = (List)((Map)new ObjectMapper().readValue((String)pf2.get("expression"), Map.class)).get("searchFieldPropertyMapping");
                    found = StreamSupport.stream((Collection)pf2Fields).filter((Predicate)new Predicate<Map>(){

                        public boolean test(Map t) {
                            return MapUtils.getString((Map)t, (Object)"propertyValue").equals(pf1.get("propertyTypeName"));
                        }
                    }).findFirst();
                }
                catch (IOException e) {
                    throw new RuntimeException((Throwable)((Object)new PartnerManagerConnectorException(e)));
                }
                return found.isPresent() ? -1 : 1;
            }
        };
        return (List)StreamSupport.stream(propertyDefinitions).filter((Predicate)new Predicate<Map>(){

            public boolean test(Map t) {
                return "LOOKUP PROPERTIES".equals(MapUtils.getString((Map)t, (Object)"source"));
            }
        }).sorted((Comparator)comparator).collect(Collectors.toCollection((Supplier)new Supplier<List<Map<String, Object>>>(){

            public List<Map<String, Object>> get() {
                return new ArrayList<Map<String, Object>>();
            }
        }));
    }

    public void readAndLoadEndpointProperties(String endpointName, TransmissionSession transmissionSession, MuleEvent muleEvent) throws Exception {
        List<Map<String, Serializable>> endpoints = this.tpmClient.search(TpmClient.Resource.ENDPOINT, String.format("name == '%s' and endpointType == '%s'", endpointName, "RECEIVE"), null, null, null, null);
        if (endpoints.isEmpty()) {
            throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)("No receive endpoint found with name " + endpointName)));
        }
        Map<String, Serializable> endpoint = endpoints.get(0);
        List propertyDefinitions = (List)((Object)endpoint.get("propertyDefinitions"));
        Map properties = (Map)transmissionSession.get((Object)"properties");
        for (Map propertyDefinition : propertyDefinitions) {
            String propertyValue = this.readProperty((String)propertyDefinition.get("source"), (String)propertyDefinition.get("expression"), muleEvent);
            if (propertyValue == null) continue;
            properties.put((String)propertyDefinition.get("propertyTypeName"), propertyValue);
        }
    }

    private String readProperty(String source, String expression, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        if (source.equals("MEL EXPRESSION")) {
            Object evaluation;
            if (this.isDefined(muleEvent, expression) && (evaluation = muleEvent.getMuleContext().getExpressionManager().evaluate(expression, muleEvent)) != null) {
                return muleEvent.getMuleContext().getExpressionManager().evaluate(expression, muleEvent).toString();
            }
        } else {
            if (source.equals("CONSTANT")) {
                return expression;
            }
            if (source.equals("INBOUND PROPERTIES")) {
                if (this.isDefined(muleEvent, expression)) {
                    return (String)muleEvent.getMessage().getInboundProperty(expression);
                }
            } else if (source.equals("OUTBOUND PROPERTIES") && this.isDefined(muleEvent, expression)) {
                return (String)muleEvent.getMessage().getOutboundProperty(expression);
            }
        }
        return null;
    }

    protected String readLookupProperty(String expression, Map<String, Object> properties, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        if (this.isDefined(muleEvent, expression)) {
            try {
                Map lookUpConfiguration = (Map)new ObjectMapper().readValue(expression, Map.class);
                Map<String, Serializable> queryFields = this.createLookupQueryFieldsFromHarvestedProperties(properties, lookUpConfiguration);
                if (SINGLE_FIELD_CAPTURE_TYPE.equals(lookUpConfiguration.get("captureType"))) {
                    String lookupTableId = MapUtils.getString((Map)lookUpConfiguration, (Object)"lookupTableId");
                    String lookupTableKeyId = MapUtils.getString((Map)lookUpConfiguration, (Object)"lookupTableKeyId");
                    String captureFieldId = MapUtils.getString((Map)lookUpConfiguration, (Object)"captureFieldId");
                    List<Entry> lookupEntries = this.tpmClient.lookupByIds(lookupTableId, lookupTableKeyId, queryFields);
                    if (!lookupEntries.isEmpty()) {
                        return (String)lookupEntries.get(0).getAdditionalProperties().get(captureFieldId);
                    }
                    return null;
                }
            }
            catch (IOException e) {
                throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)"Could not parse JSON 'expression' for LookUp Property, expression was '%s'", (Object[])new Object[]{expression}), e);
            }
            catch (TpmClientException e) {
                throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)"Could not perform property lookup during LOOKUP PROPERTIES extraction."), e);
            }
        }
        return null;
    }

    private Map<String, Serializable> createLookupQueryFieldsFromHarvestedProperties(Map<String, Object> properties, Map lookUpConfiguration) {
        HashMap<String, Serializable> queryFields = new HashMap<String, Serializable>();
        List fieldMappings = (List)lookUpConfiguration.get("searchFieldPropertyMapping");
        for (Map fieldMapping : fieldMappings) {
            String fieldId = MapUtils.getString((Map)fieldMapping, (Object)"fieldId");
            String harvestedPropertyName = MapUtils.getString((Map)fieldMapping, (Object)"propertyValue");
            String harvestedPropertyValue = MapUtils.getString(properties, (Object)harvestedPropertyName);
            queryFields.put(fieldId, (Serializable)((Object)harvestedPropertyValue));
        }
        return queryFields;
    }

    private boolean isDefined(MuleEvent muleEvent, String expression) {
        if (muleEvent != null) {
            return true;
        }
        logger.error("Mule event is undefined so the following expression cannot be evaluated: " + expression);
        return false;
    }
}

