/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.b2b.adapter;

import com.modus.activity.document.reader.DocumentEnvelope;
import com.modus.activity.document.reader.DocumentReader;
import com.modus.mule.modules.apm.AsyncTransactionSynchronizer;
import com.modus.mule.modules.apm.ConnectorContext;
import com.modus.mule.modules.apm.PartnerManagerConnector;
import com.modus.mule.modules.apm.b2b.adapter.AbstractB2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.impl.DefaultConfig;
import com.modus.mule.modules.apm.b2b.impl.DefaultQueryObject;
import com.modus.mule.modules.apm.b2b.impl.DefaultTransmission;
import com.modus.tpm.api.model.DocumentDefinition;
import com.modus.tpm.api.model.InboundFormatOptions;
import com.modus.tpm.api.model.Partnership;
import com.modus.tpm.client.TpmClient;
import com.modus.tracker.api.model.BusinessDocument;
import com.modus.tracker.client.TrackerClient;
import com.modus.tracker.model.TransactionCreate;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class EdifactB2BProviderApiAdapter
extends AbstractB2BProviderApiAdapter {
    private static final String UNB0201 = "unb0201";
    private static final String UNB0202 = "unb0202";
    private static final String UNG0201 = "ung0201";
    private static final String UNG0202 = "ung0202";
    private static final String UNB0301 = "unb0301";
    private static final String UNB0302 = "unb0302";
    private static final String UNG0301 = "ung0301";
    private static final String UNG0302 = "ung0302";
    private static final String UNB05 = "unb05";
    private static final String UNH01 = "unh01";
    private static final String MESSAGE_REFERENCE_CONTROL_NUMBER_PROPERTY_TYPE_ID = "a70ef4e8-408b-4771-a359-9bdfde2e2b53";
    private static final String INTERCHANGE_CONTROL_REFERENCE_PROPERTY_TYPE_ID = "d58272ea-20e0-4ef0-8f45-e07987c1b268";
    private static final String EDIFACT_INTERCHANGE_SENDER_ID_PROPERTY_TYPE_ID = "ccfdbdef-f08b-44fe-b7e5-a0991d5b2fef";
    private static final String INTERCHANGE_SENDER_ID_QUALIFIER_PROPERTY_TYPE_ID = "de899654-39cd-48be-8ab1-0968fdf25b79";
    private static final String EDIFACT_INTERCHANGE_RECEIVER_ID_PROPERTY_TYPE_ID = "1106de52-dabd-4391-87c2-e4b91a9cf8a7";
    private static final String INTERCHANGE_RECEIVER_ID_QUALIFIER_PROPERTY_TYPE_ID = "b6460180-7aed-4298-92ba-ade1ab458d05";
    private final DocumentReader edifactDocumentReader;
    private final PartnerManagerConnector partnerManagerConnector;

    public EdifactB2BProviderApiAdapter(ConnectorContext connectorContext, PartnerManagerConnector partnerManagerConnector, DocumentReader edifactDocumentReader) {
        super(connectorContext);
        this.edifactDocumentReader = edifactDocumentReader;
        this.partnerManagerConnector = partnerManagerConnector;
    }

    @Override
    public String getName() {
        return "EDIFACT";
    }

    @Override
    public Config getConfig(Direction direction, QueryObject queryObject) throws Exception {
        QueryObject queryObjectApiVersion2_3 = this.mapToQueryObjectPartnershipByIdentityApiVersion23(queryObject);
        Partnership partnership = this.connectorContext.getTpmClient().getPartnershipByIdentifiers((String)queryObjectApiVersion2_3.get((Object)"fromPartyIdentifier"), (String)queryObjectApiVersion2_3.get((Object)"toPartyIdentifier"));
        DocumentDefinition documentDefinition = this.connectorContext.getTpmClient().resolveDocumentDefinition(partnership.getId(), TpmClient.Standard.EDIFACT, (String)queryObjectApiVersion2_3.get((Object)"version"), (String)queryObjectApiVersion2_3.get((Object)"messageType"));
        DefaultConfig edifactConfig = new DefaultConfig();
        if (direction.equals((Object)Direction.INBOUND)) {
            InboundFormatOptions inboundFormatOptions = documentDefinition.getInboundFormatOptions();
            if (inboundFormatOptions == null) {
                throw new Exception(String.format("Undefined inbound EDIFACT options for version %s and message type %s", queryObjectApiVersion2_3.get((Object)"version"), queryObjectApiVersion2_3.get((Object)"messageType")));
            }
            Map options = inboundFormatOptions.getAdditionalProperties();
            edifactConfig.put("valueLengthErrorFail", (Serializable)options.get("failIfOutsideAllowedLengthRange"));
            edifactConfig.put("invalidCharacterInValueFail", (Serializable)options.get("failIfInvalidCharacterIsUsed"));
            edifactConfig.put("wrongValuesRepeatsFail", (Serializable)options.get("failIfRepeatedValueFallsOutsideLimits"));
            edifactConfig.put("unknownSegmentFail", (Serializable)options.get("failIfUnknownSegmentsAreUsed"));
            edifactConfig.put("segmentOutOfOrderFail", (Serializable)options.get("failWhenSegmentIsOutOfOrder"));
            edifactConfig.put("unusedSegmentPresentFail", (Serializable)options.get("failWhenUnusedSegmentIsIncluded"));
            edifactConfig.put("wrongSegmentsRepeatsFail", (Serializable)options.get("failWhenASegmentRepeatsOutsideOfStandards"));
            edifactConfig.put("requireUniqueMessageNumbers", (Serializable)options.get("requireUniqueMessageControlNumbers"));
            edifactConfig.put("requireUniqueGroupNumbers", (Serializable)options.get("requireUniqueGroupControlNumbers"));
            edifactConfig.put("requireUniqueInterchangeReferences", (Serializable)options.get("requireUniqueInterchangeControlNumbers"));
            edifactConfig.put("dataSeparator", (Serializable)options.get("subElementSeparator"));
            edifactConfig.put("componentSeparator", (Serializable)options.get("componentSeparator"));
            edifactConfig.put("repetitionSeparator", (Serializable)options.get("repetitionSeparatorCharacter"));
            edifactConfig.put("segmentTerminator", (Serializable)options.get("segmentTerminator"));
            edifactConfig.put("releaseCharacter", (Serializable)options.get("releaseCharacter"));
            edifactConfig.put("stringSubstitutionChar", (Serializable)options.get("replaceChar"));
            edifactConfig.put("schema", documentDefinition.getSchemaDefinition());
        } else {
            InboundFormatOptions outboundFormatOptions = documentDefinition.getOutboundFormatOptions();
            if (outboundFormatOptions == null) {
                throw new Exception(String.format("Undefined outbound EDIFACT options for version %s and message type %s", queryObjectApiVersion2_3.get((Object)"version"), queryObjectApiVersion2_3.get((Object)"messageType")));
            }
            Map options = outboundFormatOptions.getAdditionalProperties();
            edifactConfig.put("invalidCharacterInValueFail", (Serializable)options.get("failIfInvalidCharacterIsUsed"));
            edifactConfig.put("stringSubstitutionChar", (Serializable)options.get("replaceChar"));
            edifactConfig.put("characterEncoding", (Serializable)options.get("characterEncoding"));
            edifactConfig.put("sendSyntaxVersion", (Serializable)options.get("interchangeControlVersionNumber"));
            edifactConfig.put("dataSeparator", (Serializable)options.get("subElementSeparator"));
            edifactConfig.put("componentSeparator", (Serializable)options.get("componentSeparator"));
            edifactConfig.put("repetitionSeparator", (Serializable)options.get("repetitionSeparatorCharacter"));
            edifactConfig.put("segmentTerminator", (Serializable)options.get("segmentTerminator"));
            edifactConfig.put("releaseCharacter", (Serializable)options.get("releaseCharacter"));
            edifactConfig.put("lineEnding", (Serializable)options.get("lineEndingBetweenSegments"));
            edifactConfig.put("sendGroups", (Serializable)options.get("requireGroups"));
            edifactConfig.put("sendUniqueGroupNumbers", (Serializable)options.get("requireUniqueGroupNumbers"));
            edifactConfig.put("sendUniqueMessageNumbers", (Serializable)options.get("requireUniqueMessageControlNumbers"));
            edifactConfig.put("initialInterchangeNumber", (Serializable)options.get("initialInterchangeNumber"));
            edifactConfig.put("initialGroupNumber", (Serializable)options.get("initialGroupNumber"));
            edifactConfig.put("initialMessageNumber", (Serializable)options.get("initialMessageNumber"));
            edifactConfig.put("alwaysSendUna", (Serializable)options.get("alwaysSendUna"));
            edifactConfig.put("schema", documentDefinition.getSchemaDefinition());
            edifactConfig.put("defaultTestIndicator", null);
            if (options.get("interchangeAckRequest").equals(1)) {
                edifactConfig.put("ackRequested", true);
            } else {
                edifactConfig.put("ackRequested", false);
            }
        }
        return edifactConfig;
    }

    @Override
    public Transmission readTransmission(Direction direction, QueryObject queryObject) throws B2BProviderException {
        Transmission transmission = null;
        try {
            QueryObject queryObjectApiVersion2 = this.mapToQueryObjectFindEventsByTokenApiVersion2(queryObject);
            if (queryObjectApiVersion2.containsKey((Object)UNB05)) {
                String query = String.format("documentProperties.documentPropertyTypeId == '%s' and documentProperties.documentPropertyValue == '%s'", INTERCHANGE_CONTROL_REFERENCE_PROPERTY_TYPE_ID, queryObjectApiVersion2.get((Object)UNB05));
                List<Map<String, Serializable>> businessDocuments = this.connectorContext.getTrackerClient().search(TrackerClient.Resource.BUSINESS_DOCUMENT, query, null, null, null, (Boolean)false);
                for (Map<String, Serializable> businessDocument : businessDocuments) {
                    if (!this.containsDocumentPropertyTypeIdAndValue(businessDocument, EDIFACT_INTERCHANGE_SENDER_ID_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)UNB0201)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_SENDER_ID_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)UNB0202)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, EDIFACT_INTERCHANGE_RECEIVER_ID_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)UNB0301)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_RECEIVER_ID_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)UNB0302))) continue;
                    return new DefaultTransmission();
                }
            } else if (queryObjectApiVersion2.containsKey((Object)UNH01)) {
                String query = String.format("documentProperties.documentPropertyTypeId == '%s' and documentProperties.documentPropertyValue == '%s'", MESSAGE_REFERENCE_CONTROL_NUMBER_PROPERTY_TYPE_ID, queryObjectApiVersion2.get((Object)UNH01));
                List<Map<String, Serializable>> businessDocuments = this.connectorContext.getTrackerClient().search(TrackerClient.Resource.BUSINESS_DOCUMENT, query, null, null, null, (Boolean)false);
                for (Map<String, Serializable> businessDocument : businessDocuments) {
                    if (!this.containsDocumentPropertyTypeIdAndValue(businessDocument, EDIFACT_INTERCHANGE_SENDER_ID_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)UNB0201)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_SENDER_ID_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)UNB0202)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, EDIFACT_INTERCHANGE_RECEIVER_ID_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)UNB0301)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_RECEIVER_ID_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)UNB0302))) continue;
                    return new DefaultTransmission();
                }
            }
        }
        catch (Exception e) {
            throw new B2BProviderException((Throwable)e);
        }
        return transmission;
    }

    @Override
    public void writeTransmission(Direction direction, Transmission transmission, TransmissionContext transmissionContext, TransmissionType transmissionType, TransmissionSession transmissionSession, Boolean asynchronous) throws Exception {
        TransactionCreate transaction = new TransactionCreate();
        transaction.setId((String)transmissionSession.get((Object)"transactionId"));
        transaction.setMuleTransactionId((String)transmissionSession.get((Object)"muleTransactionId"));
        transaction.setMuleEventId((String)transmissionSession.get((Object)"muleEventId"));
        transaction.setOriginalTransactionId((String)transmissionSession.get((Object)"originalTransactionId"));
        transaction.setProcessedAt(new Date());
        if (transmissionContext.getMuleEvent() != null) {
            transaction.setApplicationName(transmissionContext.getMuleEvent().getMuleContext().getConfiguration().getId());
        } else {
            transaction.setApplicationName(this.connectorContext.getMuleContext().getConfiguration().getId());
        }
        DocumentEnvelope<Object> documentEnvelope = new DocumentEnvelope<Object>();
        documentEnvelope.setContent(transmission.get((Object)"edi"));
        documentEnvelope.setCreatedAt(new Date());
        documentEnvelope.setDirection(direction.toString());
        documentEnvelope.setFilename((String)transmission.get((Object)"filename"));
        documentEnvelope.setFormat("EDIFACT");
        if (!asynchronous.booleanValue()) {
            documentEnvelope.setFileUrl(this.connectorContext.getFileStorageProvider().store(transmissionContext.getMuleEvent(), transmission.get((Object)"content")));
        }
        List<BusinessDocument> businessDocuments = this.edifactDocumentReader.read(documentEnvelope);
        for (BusinessDocument businessDocument : businessDocuments) {
            try {
                this.partnerManagerConnector.getPropertyReader().readAndLoadDocumentProperties(businessDocument, transmissionSession, transmissionContext.getMuleEvent());
            }
            catch (Exception e) {
                this.partnerManagerConnector.logOrThrowException(transaction, e);
            }
        }
        transaction.setBusinessDocuments(businessDocuments);
        if (asynchronous.booleanValue()) {
            this.partnerManagerConnector.getTaskQueue().put(new AsyncTransactionSynchronizer.CreateTransactionTask().setMuleEvent(transmissionContext.getMuleEvent()).setFile((Serializable)transmission.get((Object)"content")).setTransaction(transaction));
        } else {
            this.connectorContext.getTrackerClient().createTransaction(transaction);
        }
    }

    private QueryObject mapToQueryObjectPartnershipByIdentityApiVersion23(QueryObject queryObject) throws Exception {
        DefaultQueryObject queryObjectApiVersion2_3 = new DefaultQueryObject();
        block8: for (Map.Entry entry : queryObject.entrySet()) {
            switch ((String)entry.getKey()) {
                case "interchangeSenderId": {
                    queryObjectApiVersion2_3.put("fromPartyIdentifier", entry.getValue());
                    continue block8;
                }
                case "interchangeReceiverId": {
                    queryObjectApiVersion2_3.put("toPartyIdentifier", entry.getValue());
                    continue block8;
                }
            }
            queryObjectApiVersion2_3.put(entry.getKey(), entry.getValue());
        }
        return queryObjectApiVersion2_3;
    }

    private QueryObject mapToQueryObjectFindEventsByTokenApiVersion2(QueryObject queryObject) throws Exception {
        DefaultQueryObject queryObjectApiVersion2 = new DefaultQueryObject();
        block22: for (Map.Entry entry : queryObject.entrySet()) {
            switch ((String)entry.getKey()) {
                case "interchangeSenderId": {
                    queryObjectApiVersion2.put(UNB0201, entry.getValue());
                    continue block22;
                }
                case "interchangeSenderIdQualifier": {
                    queryObjectApiVersion2.put(UNB0202, entry.getValue());
                    continue block22;
                }
                case "applicationSenderId": {
                    queryObjectApiVersion2.put(UNG0201, entry.getValue());
                    continue block22;
                }
                case "applicationSenderIdQualifier": {
                    queryObjectApiVersion2.put(UNG0202, entry.getValue());
                    continue block22;
                }
                case "interchangeReceiverId": {
                    queryObjectApiVersion2.put(UNB0301, entry.getValue());
                    continue block22;
                }
                case "interchangeReceiverIdQualifier": {
                    queryObjectApiVersion2.put(UNB0302, entry.getValue());
                    continue block22;
                }
                case "applicationReceiverId": {
                    queryObjectApiVersion2.put(UNG0301, entry.getValue());
                    continue block22;
                }
                case "applicationReceiverIdQualifier": {
                    queryObjectApiVersion2.put(UNG0302, entry.getValue());
                    continue block22;
                }
                case "interchangeControlReference": {
                    queryObjectApiVersion2.put(UNB05, entry.getValue());
                    continue block22;
                }
            }
            queryObjectApiVersion2.put(entry.getKey(), entry.getValue());
        }
        return queryObjectApiVersion2;
    }
}

