/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.b2b.adapter;

import com.modus.mule.modules.apm.ConnectorContext;
import com.modus.mule.modules.apm.b2b.adapter.AbstractB2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.impl.DefaultConfig;
import com.modus.mule.modules.apm.b2b.impl.DefaultQueryObject;
import com.modus.mule.modules.apm.exchange.writer.ExchangeHeader;
import com.modus.mule.modules.apm.exchange.writer.FtpsExchangeWriterCallback;
import com.modus.tpm.api.model.Endpoint;
import com.modus.tpm.api.model.Partnership;
import com.modus.tpm.api.model.TransportOptions;
import com.modus.tpm.client.TpmClient;
import com.modus.tracker.client.TrackerClient;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.Serializable;
import java.util.Map;

public class FtpsB2BProviderApiAdapter
extends AbstractB2BProviderApiAdapter {
    public FtpsB2BProviderApiAdapter(ConnectorContext connectorContext) {
        super(connectorContext);
    }

    @Override
    public Config getConfig(Direction direction, QueryObject queryObject) throws Exception {
        QueryObject queryObjectApiVersion2_3 = this.mapToQueryObjectApiVersion23(direction, queryObject);
        Partnership partnership = this.connectorContext.getTpmClient().getPartnershipByIdentifiers((String)queryObjectApiVersion2_3.get((Object)"fromPartyIdentifier"), (String)queryObjectApiVersion2_3.get((Object)"toPartyIdentifier"));
        Endpoint endpoint = this.connectorContext.getTpmClient().resolveEndpoint(partnership.getId(), direction.equals((Object)Direction.INBOUND) ? TpmClient.EndpointType.RECEIVE : TpmClient.EndpointType.SEND, "FTPS", (String)queryObjectApiVersion2_3.get((Object)"standard"), (String)queryObjectApiVersion2_3.get((Object)"version"), (String)queryObjectApiVersion2_3.get((Object)"messageType"));
        TransportOptions options = endpoint.getTransportOptions();
        DefaultConfig config = new DefaultConfig();
        config.put("host", (Serializable)options.getAdditionalProperties().get("host"));
        config.put("port", (Serializable)options.getAdditionalProperties().get("port"));
        config.put("username", (Serializable)options.getAdditionalProperties().get("username"));
        config.put("password", (Serializable)options.getAdditionalProperties().get("password"));
        config.put("serverValidationEnabled", (Serializable)options.getAdditionalProperties().get("serverValidationEnabled"));
        config.put("keystorePath", (Serializable)options.getAdditionalProperties().get("keystorePath"));
        config.put("transferMode", (Serializable)options.getAdditionalProperties().get("transferMode"));
        config.put("activeReportedIpAddress", (Serializable)options.getAdditionalProperties().get("activeReportedIpAddress"));
        config.put("activeMinPort", (Serializable)options.getAdditionalProperties().get("activeMinPort"));
        config.put("activeMaxPort", (Serializable)options.getAdditionalProperties().get("activeMaxPort"));
        config.put("sslMode", (Serializable)options.getAdditionalProperties().get("sslMode"));
        config.put("path", (Serializable)options.getAdditionalProperties().get("path"));
        config.put("filename", (Serializable)options.getAdditionalProperties().get("filename"));
        if (direction.equals((Object)Direction.INBOUND)) {
            config.put("maxDownloadThreads", (Serializable)options.getAdditionalProperties().get("maxDownloadThreads"));
            config.put("pollingFrequency", (Serializable)options.getAdditionalProperties().get("pollingFrequency"));
            config.put("moveToDirectory", (Serializable)options.getAdditionalProperties().get("moveToDirectory"));
        } else {
            config.put("uploadTempDirectory", (Serializable)options.getAdditionalProperties().get("uploadTempDirectory"));
        }
        return config;
    }

    @Override
    public Transmission readTransmission(Direction direction, QueryObject queryObject) throws B2BProviderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTransmission(Direction direction, Transmission transmission, TransmissionContext transmissionContext, TransmissionType transmissionType, TransmissionSession transmissionSession, Boolean asynchronous) throws Exception {
        ExchangeHeader exchangeHeader = new ExchangeHeader();
        exchangeHeader.setDirection(direction.toString());
        exchangeHeader.setTransactionId((String)transmissionSession.get((Object)"transactionId"));
        exchangeHeader.setFilename((String)transmission.get((Object)"filename"));
        exchangeHeader.setMuleEventId((String)transmissionSession.get((Object)"muleEventId"));
        exchangeHeader.setMuleTransactionId((String)transmissionSession.get((Object)"muleTransactionId"));
        FtpsExchangeWriterCallback exchangeWriterCallback = new FtpsExchangeWriterCallback(transmission);
        this.exchangeWriter.write(TrackerClient.ExchangeType.FTPS, transmissionContext.getMuleEvent(), exchangeWriterCallback, exchangeHeader, transmission.get((Object)"content"));
    }

    @Override
    public String getName() {
        return "FTPS";
    }

    private QueryObject mapToQueryObjectApiVersion23(Direction direction, QueryObject queryObject) throws Exception {
        DefaultQueryObject queryObjectApiVersion2_3 = new DefaultQueryObject();
        block10: for (Map.Entry entry : queryObject.entrySet()) {
            switch ((String)entry.getKey()) {
                case "partnerName": {
                    if (direction.equals((Object)Direction.INBOUND)) {
                        queryObjectApiVersion2_3.put("fromPartyIdentifier", entry.getValue());
                        continue block10;
                    }
                    queryObjectApiVersion2_3.put("toPartyIdentifier", entry.getValue());
                    continue block10;
                }
                case "partnerIdentifier": {
                    if (direction.equals((Object)Direction.INBOUND)) {
                        queryObjectApiVersion2_3.put("fromPartyIdentifier", entry.getValue());
                        continue block10;
                    }
                    queryObjectApiVersion2_3.put("toPartyIdentifier", entry.getValue());
                    continue block10;
                }
                case "standard": {
                    if (((String)entry.getValue()).equals("EDI_X12")) {
                        queryObjectApiVersion2_3.put(entry.getKey(), "X12");
                        continue block10;
                    }
                    if (((String)entry.getValue()).equals("FLAT_FILE")) {
                        queryObjectApiVersion2_3.put(entry.getKey(), "CSV");
                        continue block10;
                    }
                    queryObjectApiVersion2_3.put(entry.getKey(), entry.getValue());
                    continue block10;
                }
            }
            queryObjectApiVersion2_3.put(entry.getKey(), entry.getValue());
        }
        return queryObjectApiVersion2_3;
    }
}

