/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.b2b.adapter;

import com.modus.activity.document.reader.DocumentEnvelope;
import com.modus.activity.document.reader.DocumentReader;
import com.modus.mule.modules.apm.AsyncTransactionSynchronizer;
import com.modus.mule.modules.apm.ConnectorContext;
import com.modus.mule.modules.apm.PartnerManagerConnector;
import com.modus.mule.modules.apm.b2b.adapter.AbstractB2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.impl.DefaultConfig;
import com.modus.mule.modules.apm.b2b.impl.DefaultQueryObject;
import com.modus.mule.modules.apm.b2b.impl.DefaultTransmission;
import com.modus.tpm.api.model.DocumentDefinition;
import com.modus.tpm.api.model.InboundFormatOptions;
import com.modus.tpm.api.model.Partnership;
import com.modus.tpm.client.TpmClient;
import com.modus.tracker.api.model.BusinessDocument;
import com.modus.tracker.client.TrackerClient;
import com.modus.tracker.model.TransactionCreate;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class X12B2BProviderApiAdapter
extends AbstractB2BProviderApiAdapter {
    private static final String GS06 = "gs06";
    private static final String ISA13 = "isa13";
    private static final String GS03 = "gs03";
    private static final String ISA08 = "isa08";
    private static final String ISA07 = "isa07";
    private static final String GS02 = "gs02";
    private static final String ISA06 = "isa06";
    private static final String ISA05 = "isa05";
    private static final String ST02 = "st02";
    private static final String INTERCHANGE_CONTROL_NUMBER_PROPERTY_TYPE_ID = "dc0312f3-bad1-461a-a164-a9fe4ceaa0d5";
    private static final String FUNCTIONAL_GROUP_CONTROL_NUMBER_PROPERTY_TYPE_ID = "17180178-42e5-4e1f-a023-0c379b9c413c";
    private static final String TRANSACTION_SET_CONTROL_NUMBER_PROPERTY_TYPE_ID = "5e1b12ea-b75b-4b79-9ccd-fa4e5a684ca5";
    private static final String INTERCHANGE_RECEIVER_QUALIFIER_PROPERTY_TYPE_ID = "9ed5863f-b791-48ec-b6d8-ba97a88708bf";
    private static final String X12_INTERCHANGE_SENDER_PROPERTY_TYPE_ID = "8872fd2a-454e-4736-a88b-e9c9a94efc2c";
    private static final String INTERCHANGE_SENDER_QUALIFIER_PROPERTY_TYPE_ID = "d3435d35-5214-4b5a-90f4-d7df24f201b5";
    private static final String X12_INTERCHANGE_RECEIVER_PROPERTY_TYPE_ID = "78ada129-c146-42f7-8ebd-ac85d6b8d597";
    private static final String APPLICATION_SENDER_CODE_PROPERTY_TYPE_ID = "a572cf25-394f-420a-b837-e75862b3504f";
    private static final String APPLICATION_RECEIVER_CODE_PROPERTY_TYPE_ID = "8a7c8e15-d38e-435c-ace1-a2a7670d44b5";
    private final DocumentReader x12DocumentReader;
    private final PartnerManagerConnector partnerManagerConnector;

    public X12B2BProviderApiAdapter(ConnectorContext connectorContext, PartnerManagerConnector partnerManagerConnector, DocumentReader x12DocumentReader) {
        super(connectorContext);
        this.x12DocumentReader = x12DocumentReader;
        this.partnerManagerConnector = partnerManagerConnector;
    }

    @Override
    public String getName() {
        return "X12";
    }

    @Override
    public Config getConfig(Direction direction, QueryObject queryObject) throws Exception {
        QueryObject queryObjectApiVersion2_3 = this.mapToQueryObjectPartnershipByIdentityApiVersion23(queryObject);
        Partnership partnership = this.connectorContext.getTpmClient().getPartnershipByIdentifiers((String)queryObjectApiVersion2_3.get((Object)"fromPartyIdentifier"), (String)queryObjectApiVersion2_3.get((Object)"toPartyIdentifier"));
        DocumentDefinition documentDefinition = this.connectorContext.getTpmClient().resolveDocumentDefinition(partnership.getId(), TpmClient.Standard.X12, (String)queryObjectApiVersion2_3.get((Object)"version"), (String)queryObjectApiVersion2_3.get((Object)"messageType"));
        DefaultConfig x12Config = new DefaultConfig();
        if (direction.equals((Object)Direction.INBOUND)) {
            InboundFormatOptions inboundFormatOptions = documentDefinition.getInboundFormatOptions();
            if (inboundFormatOptions == null) {
                throw new Exception(String.format("Undefined inbound X12 options for version %s and message type %s", queryObjectApiVersion2_3.get((Object)"version"), queryObjectApiVersion2_3.get((Object)"messageType")));
            }
            Map options = inboundFormatOptions.getAdditionalProperties();
            x12Config.put("valueLengthErrorFail", (Serializable)options.get("failIfOutsideAllowedLengthRange"));
            x12Config.put("unknownsSegmentFail", (Serializable)options.get("failIfUnknownSegmentsAreUsed"));
            x12Config.put("unusedSegmentPresentFail", (Serializable)options.get("failWhenUnusedSegmentIsIncluded"));
            x12Config.put("invalidCharacterInValueFail", (Serializable)options.get("failIfInvalidCharacterIsUsed"));
            x12Config.put("wrongValuesRepeatsFail", (Serializable)options.get("failIfRepeatedValueFallsOutsideLimits"));
            x12Config.put("segmentOutOfOrderFail", (Serializable)options.get("failWhenSegmentIsOutOfOrder"));
            x12Config.put("wrongSegmentsRepeatsFail", (Serializable)options.get("failWhenASegmentRepeatsOutsideOfStandards"));
            x12Config.put("generate999Acks", (Serializable)options.get("generate999"));
            x12Config.put("requireUniqueInterchangeNumbers", (Serializable)options.get("requireUniqueIsaControlNumbers"));
            x12Config.put("requireUniqueGroupNumbers", (Serializable)options.get("requireUniqueGsControlNumbers"));
            x12Config.put("requireUniqueTransactionNumbers", (Serializable)options.get("requireUniqueTransactionSetControlNumbers"));
            x12Config.put("stringCharacterSet", (Serializable)options.get("characterSet"));
            x12Config.put("schema", documentDefinition.getSchemaDefinition());
        } else {
            InboundFormatOptions outboundFormatOptions = documentDefinition.getOutboundFormatOptions();
            if (outboundFormatOptions == null) {
                throw new Exception(String.format("Undefined outbound X12 options for version %s and message type %s", queryObjectApiVersion2_3.get((Object)"version"), queryObjectApiVersion2_3.get((Object)"messageType")));
            }
            Map options = outboundFormatOptions.getAdditionalProperties();
            x12Config.put("repetitionSeparator", (Serializable)options.get("repetitionSeparatorCharacter"));
            x12Config.put("ackRequested", (Serializable)options.get("interchangeAckRequest"));
            x12Config.put("defaultUsageIndicator", (Serializable)options.get("usageIndicator"));
            x12Config.put("componentSeparator", (Serializable)options.get("subElementSeparator"));
            x12Config.put("versionIdentifierSuffix", (Serializable)options.get("versionReleaseIdentifier"));
            x12Config.put("segmentTerminator", (Serializable)options.get("segmentTerminator"));
            x12Config.put("dataSeparator", (Serializable)options.get("dataElementDelimiter"));
            x12Config.put("stringSubstitutionChar", (Serializable)options.get("replaceSeparatorsInPayload"));
            x12Config.put("stringCharacterSet", (Serializable)options.get("characterSet"));
            x12Config.put("characterEncoding", (Serializable)options.get("characterEncoding"));
            x12Config.put("lineEnding", (Serializable)options.get("lineEndingBetweenSegments"));
            x12Config.put("initialInterchangeNumber", (Serializable)options.get("startControlNumberValueIsa"));
            x12Config.put("initialGroupNumber", (Serializable)options.get("startControlNumberValueGs"));
            x12Config.put("initialSetNumber", (Serializable)options.get("startControlNumberValueTransactionSet"));
            x12Config.put("sendUniqueGroupNumbers", (Serializable)options.get("useUniqueGsControlNumbers"));
            x12Config.put("sendUniqueTransactionNumbers", (Serializable)options.get("useUniqueTransactionSetControlNumbers"));
            x12Config.put("implementationConventionReference", (Serializable)options.get("implementationConventionReference"));
            x12Config.put("schema", documentDefinition.getSchemaDefinition());
        }
        return x12Config;
    }

    @Override
    public Transmission readTransmission(Direction direction, QueryObject queryObject) throws B2BProviderException {
        try {
            QueryObject queryObjectApiVersion2 = this.mapToQueryObjectFindEventsByTokenApiVersion2(queryObject);
            if (queryObjectApiVersion2.containsKey((Object)ISA13)) {
                String query = String.format("documentProperties.documentPropertyTypeId == '%s' and documentProperties.documentPropertyValue == '%s'", INTERCHANGE_CONTROL_NUMBER_PROPERTY_TYPE_ID, queryObjectApiVersion2.get((Object)ISA13));
                List<Map<String, Serializable>> businessDocuments = this.connectorContext.getTrackerClient().search(TrackerClient.Resource.BUSINESS_DOCUMENT, query, null, null, null, (Boolean)false);
                for (Map<String, Serializable> businessDocument : businessDocuments) {
                    if (!this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_SENDER_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA05)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, X12_INTERCHANGE_SENDER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA06)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_RECEIVER_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA07)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, X12_INTERCHANGE_RECEIVER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA08))) continue;
                    return new DefaultTransmission();
                }
            } else if (queryObjectApiVersion2.containsKey((Object)GS06)) {
                String query = String.format("documentProperties.documentPropertyTypeId == '%s' and documentProperties.documentPropertyValue == '%s'", FUNCTIONAL_GROUP_CONTROL_NUMBER_PROPERTY_TYPE_ID, queryObjectApiVersion2.get((Object)GS06));
                List<Map<String, Serializable>> businessDocuments = this.connectorContext.getTrackerClient().search(TrackerClient.Resource.BUSINESS_DOCUMENT, query, null, null, null, (Boolean)false);
                for (Map<String, Serializable> businessDocument : businessDocuments) {
                    if (!this.containsDocumentPropertyTypeIdAndValue(businessDocument, APPLICATION_SENDER_CODE_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)GS02)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_SENDER_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA05)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, X12_INTERCHANGE_SENDER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA06)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, APPLICATION_RECEIVER_CODE_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)GS03)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_RECEIVER_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA07)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, X12_INTERCHANGE_RECEIVER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA08))) continue;
                    return new DefaultTransmission();
                }
            } else if (queryObjectApiVersion2.containsKey((Object)ST02)) {
                String query = String.format("documentProperties.documentPropertyTypeId == '%s' and documentProperties.documentPropertyValue == '%s'", TRANSACTION_SET_CONTROL_NUMBER_PROPERTY_TYPE_ID, queryObjectApiVersion2.get((Object)ST02));
                List<Map<String, Serializable>> businessDocuments = this.connectorContext.getTrackerClient().search(TrackerClient.Resource.BUSINESS_DOCUMENT, query, null, null, null, (Boolean)false);
                for (Map<String, Serializable> businessDocument : businessDocuments) {
                    if (!this.containsDocumentPropertyTypeIdAndValue(businessDocument, APPLICATION_SENDER_CODE_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)GS02)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_SENDER_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA05)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, X12_INTERCHANGE_SENDER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA06)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, APPLICATION_RECEIVER_CODE_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)GS03)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, INTERCHANGE_RECEIVER_QUALIFIER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA07)) || !this.containsDocumentPropertyTypeIdAndValue(businessDocument, X12_INTERCHANGE_RECEIVER_PROPERTY_TYPE_ID, (String)queryObjectApiVersion2.get((Object)ISA08))) continue;
                    return new DefaultTransmission();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new B2BProviderException((Throwable)e);
        }
    }

    @Override
    public void writeTransmission(Direction direction, Transmission transmission, TransmissionContext transmissionContext, TransmissionType transmissionType, TransmissionSession transmissionSession, Boolean asynchronous) throws Exception {
        TransactionCreate transaction = new TransactionCreate();
        transaction.setId((String)transmissionSession.get((Object)"transactionId"));
        transaction.setMuleTransactionId((String)transmissionSession.get((Object)"muleTransactionId"));
        transaction.setMuleEventId((String)transmissionSession.get((Object)"muleEventId"));
        transaction.setOriginalTransactionId((String)transmissionSession.get((Object)"originalTransactionId"));
        transaction.setProcessedAt(new Date());
        if (transmissionContext.getMuleEvent() != null) {
            transaction.setApplicationName(transmissionContext.getMuleEvent().getMuleContext().getConfiguration().getId());
        } else {
            transaction.setApplicationName(this.connectorContext.getMuleContext().getConfiguration().getId());
        }
        DocumentEnvelope<Object> documentEnvelope = new DocumentEnvelope<Object>();
        documentEnvelope.setContent(transmission.get((Object)"edi"));
        documentEnvelope.setCreatedAt(new Date());
        documentEnvelope.setDirection(direction.toString());
        documentEnvelope.setFilename((String)transmission.get((Object)"filename"));
        documentEnvelope.setFormat("X12");
        if (!asynchronous.booleanValue()) {
            documentEnvelope.setFileUrl(this.connectorContext.getFileStorageProvider().store(transmissionContext.getMuleEvent(), transmission.get((Object)"content")));
        }
        List<BusinessDocument> businessDocuments = this.x12DocumentReader.read(documentEnvelope);
        for (BusinessDocument businessDocument : businessDocuments) {
            try {
                this.partnerManagerConnector.getPropertyReader().readAndLoadDocumentProperties(businessDocument, transmissionSession, transmissionContext.getMuleEvent());
            }
            catch (Exception e) {
                this.partnerManagerConnector.logOrThrowException(transaction, e);
            }
        }
        transaction.setBusinessDocuments(businessDocuments);
        if (asynchronous.booleanValue()) {
            this.partnerManagerConnector.getTaskQueue().put(new AsyncTransactionSynchronizer.CreateTransactionTask().setMuleEvent(transmissionContext.getMuleEvent()).setFile((Serializable)transmission.get((Object)"content")).setTransaction(transaction));
        } else {
            this.connectorContext.getTrackerClient().createTransaction(transaction);
        }
    }

    private QueryObject mapToQueryObjectPartnershipByIdentityApiVersion23(QueryObject queryObject) throws Exception {
        DefaultQueryObject queryObjectApiVersion2_3 = new DefaultQueryObject();
        block8: for (Map.Entry entry : queryObject.entrySet()) {
            switch ((String)entry.getKey()) {
                case "interchangeSenderId": {
                    queryObjectApiVersion2_3.put("fromPartyIdentifier", entry.getValue());
                    continue block8;
                }
                case "interchangeReceiverId": {
                    queryObjectApiVersion2_3.put("toPartyIdentifier", entry.getValue());
                    continue block8;
                }
            }
            queryObjectApiVersion2_3.put(entry.getKey(), entry.getValue());
        }
        return queryObjectApiVersion2_3;
    }

    private QueryObject mapToQueryObjectFindEventsByTokenApiVersion2(QueryObject queryObject) throws Exception {
        DefaultQueryObject queryObjectApiVersion2 = new DefaultQueryObject();
        block18: for (Map.Entry entry : queryObject.entrySet()) {
            switch ((String)entry.getKey()) {
                case "interchangeSenderQualifierId": {
                    queryObjectApiVersion2.put(ISA05, entry.getValue());
                    continue block18;
                }
                case "interchangeSenderId": {
                    queryObjectApiVersion2.put(ISA06, entry.getValue());
                    continue block18;
                }
                case "applicationSenderCode": {
                    queryObjectApiVersion2.put(GS02, entry.getValue());
                    continue block18;
                }
                case "interchangeReceiverQualifierId": {
                    queryObjectApiVersion2.put(ISA07, entry.getValue());
                    continue block18;
                }
                case "interchangeReceiverId": {
                    queryObjectApiVersion2.put(ISA08, entry.getValue());
                    continue block18;
                }
                case "applicationReceiverCode": {
                    queryObjectApiVersion2.put(GS03, entry.getValue());
                    continue block18;
                }
                case "interchangeControlNumber": {
                    queryObjectApiVersion2.put(ISA13, entry.getValue());
                    continue block18;
                }
            }
            queryObjectApiVersion2.put(entry.getKey(), entry.getValue());
        }
        return queryObjectApiVersion2;
    }
}

