/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.text.WordUtils;
import org.mule.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

class BeanStore {
    private static final Logger logger = LoggerFactory.getLogger(BeanStore.class);
    private final ObjectMapper objectMapper;
    private final Map<String, BeanWrapper> beanWrappers = new HashMap<String, BeanWrapper>();
    private String lastBeanKey = null;

    public BeanStore(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void addBean(String beanId, Class<?> beanClass) {
        BeanWrapper rootBeanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)BeanUtils.instantiate(beanClass));
        this.beanWrappers.put(":" + beanId, rootBeanWrapper);
    }

    public Object addNestedBean(String rootBeanId, String nestedBeanId, String propertyPath) {
        BeanWrapper nestedBeanWrapper = this.createBean(this.beanWrappers.get(":" + rootBeanId), propertyPath);
        if (nestedBeanWrapper != null) {
            this.beanWrappers.put(propertyPath + ":" + nestedBeanId, nestedBeanWrapper);
        }
        return nestedBeanWrapper != null ? nestedBeanWrapper.getWrappedInstance() : null;
    }

    public void setProperty(String beanId, String propertyPath, String propertyName, Object propertyValue) throws ParseException, IOException {
        this.setProperty(this.beanWrappers.get(propertyPath + ":" + beanId).getWrappedInstance(), propertyName, propertyValue);
    }

    public void setProperty(Object bean, String propertyName, Object propertyValue) throws ParseException, IOException {
        if (propertyValue != null) {
            BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
            for (PropertyDescriptor propertyDescriptor : beanWrapper.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().toLowerCase().equals(propertyName.toLowerCase())) continue;
                if (propertyDescriptor.getPropertyType().isEnum()) {
                    beanWrapper.setPropertyValue(propertyDescriptor.getName(), Enum.valueOf(propertyDescriptor.getPropertyType(), propertyValue.toString().toUpperCase().replace(" ", "_")));
                    continue;
                }
                if (propertyDescriptor.getPropertyType().equals(Optional.class)) {
                    beanWrapper.setPropertyValue(propertyDescriptor.getName(), (Object)Optional.fromNullable((Object)propertyValue));
                    continue;
                }
                if (propertyDescriptor.getPropertyType().equals(Map.class)) {
                    beanWrapper.setPropertyValue(propertyDescriptor.getName(), this.objectMapper.readValue((String)propertyValue, Map.class));
                    continue;
                }
                if (propertyDescriptor.getPropertyType().equals(Set.class)) {
                    ((Set)beanWrapper.getPropertyValue(propertyDescriptor.getName())).add(propertyValue);
                    continue;
                }
                if (propertyDescriptor.getPropertyType().equals(Date.class)) {
                    Date date = DateUtils.parseDate((String)((String)propertyValue), (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss"});
                    beanWrapper.setPropertyValue(propertyDescriptor.getName(), (Object)date);
                    continue;
                }
                beanWrapper.setPropertyValue(propertyDescriptor.getName(), propertyValue);
            }
        }
    }

    public Object getBean(String id, String propertyPath) {
        BeanWrapper beanWrapper = this.beanWrappers.get(propertyPath + ":" + id);
        return beanWrapper != null ? beanWrapper.getWrappedInstance() : beanWrapper;
    }

    public List getRootBeans() {
        ArrayList<Object> rootBeans = new ArrayList<Object>();
        for (Map.Entry<String, BeanWrapper> bean : this.beanWrappers.entrySet()) {
            if (!bean.getKey().startsWith(":")) continue;
            rootBeans.add(bean.getValue().getWrappedInstance());
        }
        return rootBeans;
    }

    public Object getLastKnownBean() {
        BeanWrapper beanWrapper = this.beanWrappers.get(this.lastBeanKey);
        if (beanWrapper != null) {
            return beanWrapper.getWrappedInstance();
        }
        return null;
    }

    public void setLastKnownBean(String beanId, String propertyPath, Object bean) {
        this.lastBeanKey = propertyPath + ":" + beanId;
        if (this.beanWrappers.get(this.lastBeanKey) == null) {
            this.beanWrappers.put(this.lastBeanKey, PropertyAccessorFactory.forBeanPropertyAccess((Object)bean));
        }
    }

    private BeanWrapper createBean(BeanWrapper beanWrapper, String beanPath) {
        List<String> pathSegments = Arrays.asList(beanPath.split("\\."));
        BeanWrapper nestedBeanWrapper = beanWrapper;
        BeanWrapper lastNotNullNestedBeanWrapper = beanWrapper;
        String previousPathSegment = "";
        for (String pathSegment : pathSegments) {
            if (nestedBeanWrapper != null) {
                lastNotNullNestedBeanWrapper = nestedBeanWrapper;
                nestedBeanWrapper = this.instantiateBean(nestedBeanWrapper, pathSegment);
                previousPathSegment = pathSegment;
                continue;
            }
            logger.warn(String.format("No property found in class %s corresponding to initials '%s' in bean path '%s'", lastNotNullNestedBeanWrapper.getWrappedClass().getName(), previousPathSegment, beanPath));
        }
        return nestedBeanWrapper;
    }

    private BeanWrapper instantiateBean(BeanWrapper beanWrapper, String beanInitials) {
        for (PropertyDescriptor propertyDescriptor : beanWrapper.getPropertyDescriptors()) {
            if (BeanUtils.isSimpleValueType(propertyDescriptor.getPropertyType()) || !WordUtils.initials((String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, propertyDescriptor.getName()), (char[])new char[]{'-'}).equals(beanInitials)) continue;
            Object nestedBean = beanWrapper.getPropertyValue(propertyDescriptor.getName());
            if (nestedBean == null) {
                nestedBean = BeanUtils.instantiate((Class)beanWrapper.getPropertyType(propertyDescriptor.getName()));
                beanWrapper.setPropertyValue(propertyDescriptor.getName(), nestedBean);
            } else if (nestedBean instanceof Collection) {
                Type type = ((ParameterizedType)propertyDescriptor.getReadMethod().getGenericReturnType()).getActualTypeArguments()[0];
                Object element = BeanUtils.instantiate((Class)((Class)type));
                ((Collection)nestedBean).add(element);
                return PropertyAccessorFactory.forBeanPropertyAccess((Object)element);
            }
            return PropertyAccessorFactory.forBeanPropertyAccess((Object)nestedBean);
        }
        return null;
    }
}

