/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.cache.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.modus.commons.persistence.DataMapper;
import com.modus.commons.persistence.DataMapperFactory;
import com.modus.commons.persistence.RsqlDataMapper;
import com.modus.commons.transaction.UnitOfWork;
import com.modus.mule.modules.apm.PartnerManagerConnectorException;
import com.modus.mule.modules.apm.cache.Cache;
import com.modus.mule.modules.apm.cache.impl.DefaultDataMapper;
import com.modus.mule.modules.apm.config.BasicConfig;
import com.modus.util.remote.HttpUtils;
import cz.jirutka.rsql.parser.ast.Node;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.client.HttpClient;
import org.apache.http.shade.pmc.client.methods.HttpGet;
import org.apache.http.shade.pmc.client.utils.HttpClientUtils;
import org.mule.config.i18n.MessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class RemoteDataMapperFactory
implements DataMapperFactory {
    protected static final Map<String, String> queries = new ConcurrentHashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(RemoteDataMapperFactory.class);
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final BasicConfig connectorConfig;
    private final Method rsqlQueryMethod;
    private final Method dataMapperQueryMethod;
    private final Method dataMapperQueryUseCacheMethod;
    private static Map<Class<? extends DataMapper>, Class<? extends DataMapper>> dataMapperClasses = new HashMap<Class<? extends DataMapper>, Class<? extends DataMapper>>();
    private static final List<String> QUERY_IDS;

    public RemoteDataMapperFactory(Cache cache, HttpClient httpClient, ObjectMapper objectMapper, BasicConfig connectorConfig) throws PartnerManagerConnectorException, IOException {
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.connectorConfig = connectorConfig;
        this.rsqlQueryMethod = ReflectionUtils.findMethod(RsqlDataMapper.class, (String)"query", (Class[])new Class[]{Node.class, Integer.TYPE, Integer.TYPE, String.class, Boolean.class});
        this.dataMapperQueryUseCacheMethod = ReflectionUtils.findMethod(DataMapper.class, (String)"query", (Class[])new Class[]{String.class, Map.class, Boolean.TYPE});
        this.dataMapperQueryMethod = ReflectionUtils.findMethod(DataMapper.class, (String)"query", (Class[])new Class[]{String.class, Map.class});
        this.loadQueries(connectorConfig, httpClient, objectMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQueries(BasicConfig connectorConfig, HttpClient httpClient, ObjectMapper objectMapper) throws PartnerManagerConnectorException, IOException {
        HttpResponse httpResponse = null;
        logger.trace("Fetching queries...");
        for (String queryId : QUERY_IDS) {
            HttpGet httpGet = new HttpGet(String.format(connectorConfig.getTpmServiceAddress() + "/queryRepository/%s?apiKey=%s&environmentId=%s", queryId, connectorConfig.getApiKey(), connectorConfig.getEnvironmentId()));
            try {
                httpResponse = httpClient.execute(httpGet);
                if (httpResponse.getStatusLine().getStatusCode() == 404) {
                    throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)("Query not found for ID: " + queryId)));
                }
                if (!HttpUtils.isSuccessful(httpResponse)) {
                    throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)HttpUtils.createHttpResponseExceptionMessage("Could not fetch query: " + queryId, httpResponse)));
                }
                Map query = (Map)objectMapper.readValue(httpResponse.getEntity().getContent(), Map.class);
                queries.put(queryId, (String)query.get("query"));
            }
            finally {
                HttpClientUtils.closeQuietly(httpResponse);
            }
        }
        logger.trace(String.format("Fetched %s queries", queries.size()));
    }

    public <D extends DataMapper<?>> D createDataMapper(final Class<D> clazz) throws Exception {
        return (D)((DataMapper)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz, RsqlDataMapper.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.equals(RemoteDataMapperFactory.this.rsqlQueryMethod)) {
                    Class resultType = (Class)((ParameterizedType)clazz.getGenericInterfaces()[0]).getActualTypeArguments()[0];
                    String targetTable = null;
                    try {
                        targetTable = (String)ReflectionUtils.getField((Field)clazz.getDeclaredField("TARGET_TABLE"), (Object)clazz);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    DefaultDataMapper rsqlDataMapper = new DefaultDataMapper(RemoteDataMapperFactory.this.cache, queries, RemoteDataMapperFactory.this.objectMapper, resultType, targetTable);
                    rsqlDataMapper.setEnvironmentId(RemoteDataMapperFactory.this.connectorConfig.getEnvironmentId());
                    rsqlDataMapper.setDataMapperFactory(RemoteDataMapperFactory.this);
                    return rsqlDataMapper.query((Node)args[0], (Integer)args[1], (Integer)args[2], (String)args[3], (Boolean)args[4]);
                }
                if (dataMapperClasses.get(clazz) != null && !method.equals(RemoteDataMapperFactory.this.dataMapperQueryMethod) && !method.equals(RemoteDataMapperFactory.this.dataMapperQueryUseCacheMethod)) {
                    Class implementation = (Class)dataMapperClasses.get(clazz);
                    DataMapper dataMapper = (DataMapper)implementation.newInstance();
                    dataMapper.setEnvironmentId(RemoteDataMapperFactory.this.connectorConfig.getEnvironmentId());
                    dataMapper.setDataMapperFactory((DataMapperFactory)RemoteDataMapperFactory.this);
                    return ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod((Class)implementation, (String)method.getName(), (Class[])method.getParameterTypes()), (Object)dataMapper, (Object[])args);
                }
                DefaultDataMapper dataMapper = new DefaultDataMapper(RemoteDataMapperFactory.this.cache, queries, RemoteDataMapperFactory.this.objectMapper);
                dataMapper.setEnvironmentId(RemoteDataMapperFactory.this.connectorConfig.getEnvironmentId());
                dataMapper.setDataMapperFactory(RemoteDataMapperFactory.this);
                List<?> result = method.equals(RemoteDataMapperFactory.this.dataMapperQueryMethod) || method.equals(RemoteDataMapperFactory.this.dataMapperQueryUseCacheMethod) ? dataMapper.queryBySql((String)args[0], this.getDomainClass(ReflectionUtils.findMethod((Class)((Class)dataMapperClasses.get(clazz)), (String)"query", (Class[])new Class[]{String.class, Map.class})), (Map)args[1]) : dataMapper.queryById(method.getName(), this.getDomainClass(method), args);
                if (Collection.class.isAssignableFrom(method.getReturnType())) {
                    return result;
                }
                return Iterables.getFirst(result, null);
            }

            private Class<?> getDomainClass(Method method) {
                if (Collection.class.isAssignableFrom(method.getReturnType())) {
                    Type type = ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0];
                    if (type instanceof ParameterizedType) {
                        return (Class)((ParameterizedType)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]).getRawType();
                    }
                    return (Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0];
                }
                return method.getReturnType();
            }
        }));
    }

    public String getEnvironmentId() {
        return this.connectorConfig.getEnvironmentId();
    }

    public <D extends DataMapper<?>> D createDataMapper(Class<D> clazz, UnitOfWork unitOfWork) throws Exception {
        return this.createDataMapper(clazz);
    }

    static {
        ServiceLoader<DataMapper> serviceLoader = ServiceLoader.load(DataMapper.class);
        for (DataMapper dataMapper : serviceLoader) {
            Class<?>[] interfaces;
            for (Class<?> interface_ : interfaces = dataMapper.getClass().getInterfaces()) {
                if (!DataMapper.class.isAssignableFrom(interface_)) continue;
                dataMapperClasses.put(interface_, dataMapper.getClass());
            }
        }
        QUERY_IDS = Arrays.asList("calculateRouteStatus", "getChannels", "getDocumentDefinitionsV2", "getChannelsByPartnershipIdAndDocumentDefinitionId", "getRoutesBySourceChannelAndPartnershipId", "getDocumentDefinitionByMessageTypeAndVersionAndStandardAndPartnershipIdAndPriorityV2", "getDocumentDefinitionByMessageTypeAndVersionAndStandardAndPartnershipIdV2", "getDocumentMapsV2", "getEndpoints", "getEndpointByTransportTypeAndEndpointTypeAndPriorityAndPartnershipId", "getEndpointByTransportTypeAndEndpointTypeAndStandardAndVersionAndMessageTypeAndPartnershipIdAndPriority", "getIdentifiers", "getLookupTableByIdV2", "getLookupTableByNameV2", "getPartnerByName", "getPartnerById", "getPartnershipById", "getPartnershipByExternalPartnerId", "getRoutesBySourceChannelPartnershipIdAndTargetChannelPartnershipIdAndSourceChannelDocumentDefinitionIdAndSourceChannelTransportType", "getRoutesBySourceChannelPartnershipIdAndSourceChannelDocumentDefinitionIdAndSourceChannelTransportType", "getRoutesBySourceChannelPartnershipIdAndTargetChannelPartnershipIdAndSourceChannelDocumentDefinitionId", "getSecurityConfig", "getRosettanetAgreementsV3", "getErrorCodes");
    }
}

