/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.util.queue.QueueManager;

public class BasicConfig {
    private String apiKey;
    private String tpmServiceAddress;
    private String trackerAddress;
    private String environmentId;
    private Boolean enableCaching;
    private Integer cacheMaxExportTries;
    private Integer cacheRefreshIntervalMinutes;
    private Boolean asynchronousMode;
    private QueueManager queueManager;
    private Integer maxTotalConnections;
    private Integer connectTimeoutMs;
    private Integer connectionRequestTimeoutMs;
    private Integer socketTimeoutMs;
    private Integer maxNumberOfRetries;

    public Integer getCacheMaxExportTries() {
        return this.cacheMaxExportTries;
    }

    public void setCacheMaxExportTries(Integer cacheMaxExportTries) {
        this.cacheMaxExportTries = cacheMaxExportTries;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getTpmServiceAddress() {
        return this.tpmServiceAddress;
    }

    public void setTpmServiceAddress(String tpmServiceAddress) {
        this.tpmServiceAddress = tpmServiceAddress;
    }

    public String getTrackerAddress() {
        return this.trackerAddress;
    }

    public void setTrackerAddress(String trackerAddress) {
        this.trackerAddress = trackerAddress;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }

    public Boolean getAsynchronousMode() {
        return this.asynchronousMode;
    }

    public void setAsynchronousMode(Boolean asynchronousMode) {
        this.asynchronousMode = asynchronousMode;
    }

    public Integer getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public Boolean getEnableCaching() {
        return this.enableCaching;
    }

    public void setEnableCaching(Boolean enableCaching) {
        this.enableCaching = enableCaching;
    }

    public Integer getCacheRefreshIntervalMinutes() {
        return this.cacheRefreshIntervalMinutes;
    }

    public void setCacheRefreshIntervalMinutes(Integer cacheRefreshIntervalMinutes) {
        this.cacheRefreshIntervalMinutes = cacheRefreshIntervalMinutes;
    }

    public Integer getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public void setConnectTimeoutMs(Integer connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public Integer getConnectionRequestTimeoutMs() {
        return this.connectionRequestTimeoutMs;
    }

    public void setConnectionRequestTimeoutMs(Integer connectionRequestTimeoutMs) {
        this.connectionRequestTimeoutMs = connectionRequestTimeoutMs;
    }

    public Integer getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public void setSocketTimeoutMs(Integer socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public Integer getMaxNumberOfRetries() {
        return this.maxNumberOfRetries;
    }

    public void setMaxNumberOfRetries(Integer maxNumberOfRetries) {
        this.maxNumberOfRetries = maxNumberOfRetries;
    }

    public void testConnectivity() throws ConnectionException {
        this.doTestConnectivity("TPM Service", this.tpmServiceAddress, "v6.0", "/partnerships?apiKey=" + this.apiKey + "&environmentId=" + this.environmentId);
        this.doTestConnectivity("Tracker", this.trackerAddress, "v3.0", "/transactions?apiKey=" + this.apiKey + "&environmentId=" + this.environmentId);
    }

    public void doTestConnectivity(String serviceName, String address, String minApiVersion, String accessTestPath) throws ConnectionException {
        String responseMessage;
        int responseCode;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(address + accessTestPath).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestMethod("HEAD");
            responseCode = connection.getResponseCode();
            responseMessage = connection.getResponseMessage();
            connection.disconnect();
        }
        catch (IOException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, e.getMessage(), (Throwable)e);
        }
        if (responseCode == 401) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, responseMessage, "Invalid API key");
        }
        if (200 > responseCode || responseCode > 399) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, responseMessage, "Unexpected response code => " + responseCode + " (" + responseMessage + ")");
        }
        this.verifyApiVersion(serviceName, address, minApiVersion);
    }

    private void verifyApiVersion(String serviceName, String address, String minApiVersion) throws ConnectionException {
        Map version;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(address + "/version").openConnection();
            connection.setRequestMethod("GET");
            version = (Map)new ObjectMapper().readValue(connection.getInputStream(), Map.class);
            connection.disconnect();
        }
        catch (IOException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, e.getMessage(), (Throwable)e);
        }
        Integer normalizedApiVersion = Integer.valueOf(((String)version.get("api.version")).replace("v", "").replace(".", ""));
        Integer normalizedMinApiVersion = Integer.valueOf(minApiVersion.replace("v", "").replace(".", ""));
        if (normalizedMinApiVersion > normalizedApiVersion) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, "Unsupported service API. Minimum supported API version is " + minApiVersion + " but current " + serviceName + " API version is " + (String)version.get("api.version") + ". Downgrade installed Partner Manager Connector.");
        }
    }
}

