/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.exchange.writer;

import com.modus.mule.modules.apm.ConnectorContext;
import com.modus.mule.modules.apm.exchange.writer.ExchangeHeader;
import com.modus.mule.modules.apm.exchange.writer.ExchangeWriterCallback;
import com.modus.mule.modules.apm.filestorage.FileStorageProvider;
import com.modus.tracker.client.TrackerClient;
import com.mulesoft.api.b2b.B2BProviderException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.MessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeWriter {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeWriter.class);
    protected TrackerClient trackerClient;
    protected FileStorageProvider fileStorageProvider;

    public ExchangeWriter(ConnectorContext connectorContext) {
        this.trackerClient = connectorContext.getTrackerClient();
        this.fileStorageProvider = connectorContext.getFileStorageProvider();
    }

    public Map<String, Serializable> write(TrackerClient.ExchangeType exchangeType, MuleEvent muleEvent, ExchangeWriterCallback exchangeWriterCallback, ExchangeHeader exchangeHeader) throws B2BProviderException {
        return this.write(exchangeType, muleEvent, exchangeWriterCallback, exchangeHeader, null);
    }

    public Map<String, Serializable> write(TrackerClient.ExchangeType exchangeType, MuleEvent muleEvent, ExchangeWriterCallback exchangeWriterCallback, ExchangeHeader exchangeHeader, Object file) throws B2BProviderException {
        logger.info("Publishing " + exchangeHeader.getDirection() + " exchange with transaction ID " + exchangeHeader.getTransactionId());
        try {
            String fileUrl = this.fileStorageProvider.store(muleEvent, file);
            Map<String, Object> exchangeBody = exchangeWriterCallback.createEventContent();
            return this.trackerClient.publishExchange(exchangeType, this.constructExchange(muleEvent, exchangeHeader, exchangeBody, fileUrl));
        }
        catch (Exception e) {
            throw new B2BProviderException(MessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e);
        }
    }

    protected Map<String, Serializable> constructExchange(MuleEvent muleEvent, ExchangeHeader exchangeHeader, Map<String, Object> exchangeContent, String fileUrl) {
        HashMap<String, Serializable> exchange = new HashMap<String, Serializable>();
        if (exchangeHeader.getFilename() != null) {
            exchange.put("filename", (Serializable)((Object)exchangeHeader.getFilename()));
        }
        if (exchangeHeader.getMuleTransactionId() != null) {
            exchange.put("muleTransactionId", (Serializable)((Object)exchangeHeader.getMuleTransactionId()));
        }
        if (exchangeContent != null) {
            exchange.put("content", (Serializable)((Object)exchangeContent));
        }
        if (exchangeHeader.getOriginalTransactionId() != null) {
            exchange.put("originalTransactionId", (Serializable)((Object)exchangeHeader.getOriginalTransactionId()));
        }
        exchange.put("fileUrl", (Serializable)((Object)fileUrl));
        exchange.put("muleEventId", (Serializable)((Object)muleEvent.getId()));
        exchange.put("transactionId", (Serializable)((Object)exchangeHeader.getTransactionId()));
        exchange.put("direction", (Serializable)((Object)exchangeHeader.getDirection()));
        exchange.put("createdAt", Long.valueOf(new Date().getTime()));
        exchange.put("applicationName", (Serializable)((Object)muleEvent.getMuleContext().getConfiguration().getId()));
        exchange.put("version", (Serializable)((Object)"3.2"));
        return exchange;
    }
}

