/*
 * Decompiled with CFR 0.152.
 */
package com.modus.util;

import com.modus.util.Aws4SignerBase;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;

public class Aws4SignerForAuthorizationHeader
extends Aws4SignerBase {
    public Aws4SignerForAuthorizationHeader(URL endpointUrl, String httpMethod, String serviceName, String regionName) {
        super(endpointUrl, httpMethod, serviceName, regionName);
    }

    public String computeSignature(Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey) {
        Date now = new Date();
        String dateTimeStamp = this.dateTimeFormat.format(now);
        headers.put("x-amz-date", dateTimeStamp);
        String hostHeader = this.endpointUrl.getHost();
        int port = this.endpointUrl.getPort();
        if (port > -1) {
            hostHeader.concat(":" + Integer.toString(port));
        }
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = Aws4SignerForAuthorizationHeader.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = Aws4SignerForAuthorizationHeader.getCanonicalizedHeaderString(headers);
        String canonicalizedQueryParameters = Aws4SignerForAuthorizationHeader.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = Aws4SignerForAuthorizationHeader.getCanonicalRequest(this.endpointUrl, this.httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        String dateStamp = this.dateStampFormat.format(now);
        String scope = dateStamp + "/" + this.regionName + "/" + this.serviceName + "/" + "aws4_request";
        String stringToSign = Aws4SignerForAuthorizationHeader.getStringToSign("AWS4", "HMAC-SHA256", dateTimeStamp, scope, canonicalRequest);
        byte[] kSecret = ("AWS4" + awsSecretKey).getBytes(Charset.forName("UTF-8"));
        byte[] kDate = Aws4SignerForAuthorizationHeader.sign(dateStamp, kSecret, "HmacSHA256");
        byte[] kRegion = Aws4SignerForAuthorizationHeader.sign(this.regionName, kDate, "HmacSHA256");
        byte[] kService = Aws4SignerForAuthorizationHeader.sign(this.serviceName, kRegion, "HmacSHA256");
        byte[] kSigning = Aws4SignerForAuthorizationHeader.sign("aws4_request", kService, "HmacSHA256");
        byte[] signature = Aws4SignerForAuthorizationHeader.sign(stringToSign, kSigning, "HmacSHA256");
        String credentialsAuthorizationHeader = "Credential=" + awsAccessKey + "/" + scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + Aws4SignerForAuthorizationHeader.toHex(signature);
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        return authorizationHeader;
    }
}

