/*
 * Decompiled with CFR 0.152.
 */
package com.modus.util.remote;

import com.modus.util.remote.CustomHttpRequestRetryHandler;
import com.modus.util.remote.HttpUtils;
import com.modus.util.remote.LogHttpRequestInterceptor;
import com.modus.util.remote.RemoteException;
import com.modus.util.remote.UriBuilderFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.client.config.RequestConfig;
import org.apache.http.shade.pmc.client.methods.CloseableHttpResponse;
import org.apache.http.shade.pmc.client.methods.HttpGet;
import org.apache.http.shade.pmc.client.methods.HttpPatch;
import org.apache.http.shade.pmc.client.methods.HttpPost;
import org.apache.http.shade.pmc.client.methods.HttpPut;
import org.apache.http.shade.pmc.client.methods.HttpUriRequest;
import org.apache.http.shade.pmc.client.utils.HttpClientUtils;
import org.apache.http.shade.pmc.entity.StringEntity;
import org.apache.http.shade.pmc.impl.client.CloseableHttpClient;
import org.apache.http.shade.pmc.impl.client.HttpClientBuilder;
import org.apache.http.shade.pmc.protocol.BasicHttpContext;
import org.apache.http.shade.pmc.protocol.HttpContext;
import org.apache.http.shade.pmc.util.EntityUtils;

public class HttpClient
implements Closeable {
    public static final int DEFAULT_TIMEOUT = 5000;
    private final UriBuilderFactory uriBuilderFactory;
    private CloseableHttpClient httpClient;

    public HttpClient(String host, String apiKey, String environmentId, int maxTotalConnections, int socketTimeout, int connectTimeout, int connectionRequestTimeout, int maxNoOfRetries) throws URISyntaxException {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).build();
        this.uriBuilderFactory = new UriBuilderFactory(host, environmentId);
        this.httpClient = HttpClientBuilder.create().setRetryHandler(new CustomHttpRequestRetryHandler(maxNoOfRetries, false)).setMaxConnPerRoute(maxTotalConnections).setConnectionTimeToLive(30L, TimeUnit.SECONDS).setMaxConnTotal(maxTotalConnections).addInterceptorLast(new LogHttpRequestInterceptor(apiKey)).setDefaultRequestConfig(requestConfig).build();
    }

    public String get(String path) throws IOException, URISyntaxException {
        return this.get(path, null);
    }

    public String patch(String path) throws IOException, URISyntaxException {
        return this.patch(path, null);
    }

    public String patch(String path, String content) throws IOException, URISyntaxException {
        return this.patch(path, content, new BasicHttpContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String patch(String path, String content, HttpContext httpContext) throws IOException, URISyntaxException {
        String string;
        CloseableHttpResponse httpResponse = null;
        try {
            URI uri = this.createUri(path, null);
            HttpPatch httpPatch = new HttpPatch(uri);
            if (content != null) {
                httpPatch.setEntity(new StringEntity(content));
            }
            httpPatch.setHeader("Content-Type", "application/json");
            httpResponse = this.httpClient.execute((HttpUriRequest)httpPatch, httpContext);
            string = this.readContent(httpResponse, uri);
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpResponse);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
        return string;
    }

    public String post(String path, Map<String, String> queryParams) throws IOException, URISyntaxException {
        return this.post(path, queryParams, null, new BasicHttpContext());
    }

    public String post(String path, Map<String, String> queryParams, String content) throws IOException, URISyntaxException {
        return this.post(path, queryParams, content, new BasicHttpContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String path, Map<String, String> queryParams, String content, HttpContext httpContext) throws IOException, URISyntaxException {
        String string;
        CloseableHttpResponse httpResponse = null;
        try {
            URI uri = this.createUri(path, queryParams);
            HttpPost httpPost = new HttpPost(uri);
            if (content != null) {
                httpPost.setEntity(new StringEntity(content));
            }
            httpPost.setHeader("Content-Type", "application/json");
            httpResponse = this.httpClient.execute((HttpUriRequest)httpPost, httpContext);
            string = this.readContent(httpResponse, uri);
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpResponse);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
        return string;
    }

    public String put(String path, String content) throws IOException, URISyntaxException {
        return this.put(path, content, new BasicHttpContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String path, String content, HttpContext httpContext) throws IOException, URISyntaxException {
        String string;
        CloseableHttpResponse httpResponse = null;
        try {
            URI uri = this.createUri(path, null);
            HttpPut httpPut = new HttpPut(uri);
            if (content != null) {
                httpPut.setEntity(new StringEntity(content));
            }
            httpPut.setHeader("Content-Type", "application/json");
            httpResponse = this.httpClient.execute((HttpUriRequest)httpPut, httpContext);
            string = this.readContent(httpResponse, uri);
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpResponse);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
        return string;
    }

    public String get(String path, Map<String, String> queryParams) throws IOException, URISyntaxException {
        return this.get(path, queryParams, new BasicHttpContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String path, Map<String, String> queryParams, HttpContext httpContext) throws IOException, URISyntaxException {
        String string;
        CloseableHttpResponse httpResponse = null;
        try {
            URI uri = this.createUri(path, queryParams);
            httpResponse = this.httpClient.execute((HttpUriRequest)new HttpGet(uri), httpContext);
            string = this.readContent(httpResponse, uri);
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpResponse);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
        return string;
    }

    private String readContent(HttpResponse httpResponse, URI uri) throws IOException {
        if (HttpUtils.isSuccessful(httpResponse)) {
            if (httpResponse.getEntity() != null) {
                return EntityUtils.toString(httpResponse.getEntity());
            }
            return null;
        }
        if (httpResponse.getStatusLine().getStatusCode() == 404) {
            throw new RemoteException(HttpUtils.createHttpResponseExceptionMessage(String.format("Failed to fetch resource from URL path: %s", uri.getPath()), httpResponse), httpResponse.getStatusLine().getStatusCode());
        }
        throw new RemoteException(HttpUtils.createHttpResponseExceptionMessage(String.format("Failed to fetch resource from URL path: %s", uri.getPath()), httpResponse), httpResponse.getStatusLine().getStatusCode());
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private URI createUri(String path, Map<String, String> queryParams) throws URISyntaxException {
        return this.uriBuilderFactory.create(String.format("/%s", path), queryParams).build();
    }

    public CloseableHttpClient getHttpEngine() {
        return this.httpClient;
    }

    public void setHttpEngine(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

