/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.conn.util;

import java.util.Collections;
import java.util.List;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.conn.util.DomainType;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public final class PublicSuffixList {
    private final DomainType type;
    private final List<String> rules;
    private final List<String> exceptions;

    public PublicSuffixList(DomainType type, List<String> rules, List<String> exceptions) {
        this.type = Args.notNull(type, "Domain type");
        this.rules = Collections.unmodifiableList(Args.notNull(rules, "Domain suffix rules"));
        this.exceptions = Collections.unmodifiableList(exceptions != null ? exceptions : Collections.emptyList());
    }

    public PublicSuffixList(List<String> rules, List<String> exceptions) {
        this(DomainType.UNKNOWN, rules, exceptions);
    }

    public DomainType getType() {
        return this.type;
    }

    public List<String> getRules() {
        return this.rules;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }
}

