/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl;

import java.util.Locale;
import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.HttpResponseFactory;
import org.apache.http.shade.pmc.ProtocolVersion;
import org.apache.http.shade.pmc.ReasonPhraseCatalog;
import org.apache.http.shade.pmc.StatusLine;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.impl.EnglishReasonPhraseCatalog;
import org.apache.http.shade.pmc.message.BasicHttpResponse;
import org.apache.http.shade.pmc.message.BasicStatusLine;
import org.apache.http.shade.pmc.protocol.HttpContext;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

