/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.client;

import java.io.IOException;
import org.apache.http.shade.pmc.HttpEntity;
import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.StatusLine;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.client.HttpResponseException;
import org.apache.http.shade.pmc.client.ResponseHandler;
import org.apache.http.shade.pmc.util.EntityUtils;

@Immutable
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

