/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.client;

import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.conn.HttpClientConnectionManager;
import org.apache.http.shade.pmc.impl.client.CloseableHttpClient;
import org.apache.http.shade.pmc.impl.client.HttpClientBuilder;
import org.apache.http.shade.pmc.impl.client.MinimalHttpClient;
import org.apache.http.shade.pmc.impl.conn.PoolingHttpClientConnectionManager;

@Immutable
public class HttpClients {
    private HttpClients() {
    }

    public static HttpClientBuilder custom() {
        return HttpClientBuilder.create();
    }

    public static CloseableHttpClient createDefault() {
        return HttpClientBuilder.create().build();
    }

    public static CloseableHttpClient createSystem() {
        return HttpClientBuilder.create().useSystemProperties().build();
    }

    public static CloseableHttpClient createMinimal() {
        return new MinimalHttpClient(new PoolingHttpClientConnectionManager());
    }

    public static CloseableHttpClient createMinimal(HttpClientConnectionManager connManager) {
        return new MinimalHttpClient(connManager);
    }
}

