/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.shade.pmc.Header;
import org.apache.http.shade.pmc.HttpException;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.client.ServiceUnavailableRetryStrategy;
import org.apache.http.shade.pmc.client.methods.CloseableHttpResponse;
import org.apache.http.shade.pmc.client.methods.HttpExecutionAware;
import org.apache.http.shade.pmc.client.methods.HttpRequestWrapper;
import org.apache.http.shade.pmc.client.protocol.HttpClientContext;
import org.apache.http.shade.pmc.conn.routing.HttpRoute;
import org.apache.http.shade.pmc.impl.execchain.ClientExecChain;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace((Object)("Wait for " + nextInterval));
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

