/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.nio.protocol;

import org.apache.http.shade.pmc.HttpRequest;
import org.apache.http.shade.pmc.annotation.ThreadSafe;
import org.apache.http.shade.pmc.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.shade.pmc.nio.protocol.HttpAsyncRequestHandlerMapper;
import org.apache.http.shade.pmc.protocol.UriPatternMatcher;
import org.apache.http.shade.pmc.util.Args;

@ThreadSafe
public class UriHttpAsyncRequestHandlerMapper
implements HttpAsyncRequestHandlerMapper {
    private final UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher;

    protected UriHttpAsyncRequestHandlerMapper(UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher) {
        this.matcher = Args.notNull(matcher, "Pattern matcher");
    }

    public UriHttpAsyncRequestHandlerMapper() {
        this(new UriPatternMatcher());
    }

    public void register(String pattern, HttpAsyncRequestHandler<?> handler) {
        this.matcher.register(pattern, handler);
    }

    public void unregister(String pattern) {
        this.matcher.unregister(pattern);
    }

    protected String getRequestPath(HttpRequest request) {
        String uriPath = request.getRequestLine().getUri();
        int index = uriPath.indexOf("?");
        if (index != -1) {
            uriPath = uriPath.substring(0, index);
        } else {
            index = uriPath.indexOf("#");
            if (index != -1) {
                uriPath = uriPath.substring(0, index);
            }
        }
        return uriPath;
    }

    @Override
    public HttpAsyncRequestHandler<?> lookup(HttpRequest request) {
        return this.matcher.lookup(this.getRequestPath(request));
    }
}

