/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.protocol;

import java.io.IOException;
import org.apache.http.shade.pmc.HttpException;
import org.apache.http.shade.pmc.HttpRequest;
import org.apache.http.shade.pmc.HttpRequestInterceptor;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.protocol.HttpContext;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

