/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.protocol;

import java.io.IOException;
import org.apache.http.shade.pmc.HttpEntityEnclosingRequest;
import org.apache.http.shade.pmc.HttpException;
import org.apache.http.shade.pmc.HttpRequest;
import org.apache.http.shade.pmc.HttpRequestInterceptor;
import org.apache.http.shade.pmc.annotation.ThreadSafe;
import org.apache.http.shade.pmc.protocol.HttpContext;
import org.apache.http.shade.pmc.protocol.HttpDateGenerator;
import org.apache.http.shade.pmc.util.Args;

@ThreadSafe
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

