/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.mule.api.ConnectionException;
import org.mule.modules.salesforce.BaseSalesforceConnector;
import org.mule.modules.salesforce.SalesforceConnector;
import org.mule.modules.salesforce.SalesforceLongPollingTransport;

public class SalesforceBayeuxClient
extends BayeuxClient {
    protected static final int HANDSHAKE_TIMEOUT = 30000;
    protected static final int LONG_POLLING_TIMEOUT = 120000;
    protected static final Map<String, Object> LONG_POLLING_OPTIONS = SalesforceBayeuxClient.createLongPollingOptions();
    protected static final Logger LOGGER = Logger.getLogger(SalesforceBayeuxClient.class);
    protected static final String LOGIN_COOKIE = "login";
    protected static final String LOCALEINFO_COOKIE = "com.salesforce.LocaleInfo";
    protected static final String SESSIONID_COOKIE = "sid";
    protected static final String LANGUAGE_COOKIE = "language";
    protected Map<String, ClientSessionChannel.MessageListener> subscriptions;
    protected Map<String, ClientSessionChannel.MessageListener> currentSubscriptions;
    protected BaseSalesforceConnector salesforceConnector;
    private boolean needToResubscribe = false;

    private static Map<String, Object> createLongPollingOptions() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("timeout", 120000);
        return Collections.unmodifiableMap(result);
    }

    public SalesforceBayeuxClient(BaseSalesforceConnector salesforceConnector) throws MalformedURLException {
        super("https://" + new URL(salesforceConnector.getConnection().getConfig().getServiceEndpoint()).getHost() + "/cometd/30.0", (ClientTransport)SalesforceLongPollingTransport.create(salesforceConnector, LONG_POLLING_OPTIONS), new ClientTransport[0]);
        this.salesforceConnector = salesforceConnector;
        this.subscriptions = Collections.synchronizedMap(new HashMap());
        this.currentSubscriptions = Collections.synchronizedMap(new HashMap());
        this.setCookies();
        this.getChannel("/meta/connect").addListener((ClientSessionChannel.ClientSessionChannelListener)new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                LOGGER.debug((Object)("### new message:: " + message.getId()));
                LOGGER.debug((Object)("isSuccessful: " + message.isSuccessful()));
                LOGGER.debug((Object)("state: " + SalesforceBayeuxClient.this.getState()));
                LOGGER.debug((Object)("isConnected: " + SalesforceBayeuxClient.this.isConnected()));
                LOGGER.debug((Object)("needToResubscribe: " + SalesforceBayeuxClient.this.needToResubscribe));
                if (message.isSuccessful() && SalesforceBayeuxClient.this.subscriptions.size() > 0) {
                    for (String subscriptionChannel : SalesforceBayeuxClient.this.subscriptions.keySet()) {
                        LOGGER.info((Object)("subscribing " + subscriptionChannel + " for the first time"));
                        SalesforceBayeuxClient.this.getChannel(subscriptionChannel).subscribe(SalesforceBayeuxClient.this.subscriptions.get(subscriptionChannel));
                    }
                    SalesforceBayeuxClient.this.subscriptions.clear();
                } else if (!message.isSuccessful() && SalesforceBayeuxClient.this.getState() == BayeuxClient.State.REHANDSHAKING) {
                    SalesforceBayeuxClient.this.needToResubscribe = true;
                } else if (SalesforceBayeuxClient.this.needToResubscribe && SalesforceBayeuxClient.this.isConnected()) {
                    SalesforceBayeuxClient.this.resubscribe();
                    SalesforceBayeuxClient.this.needToResubscribe = false;
                }
            }
        });
    }

    private void resubscribe() {
        for (String subscriptionChannel : this.currentSubscriptions.keySet()) {
            LOGGER.info((Object)("Re-Subscribing to channel: " + subscriptionChannel));
            this.getChannel(subscriptionChannel).subscribe(this.currentSubscriptions.get(subscriptionChannel));
        }
    }

    private void setCookies() {
        this.setCookie(LOCALEINFO_COOKIE, "us");
        this.setCookie(LOGIN_COOKIE, this.salesforceConnector.getConnection().getConfig().getUsername());
        this.setCookie(SESSIONID_COOKIE, this.salesforceConnector.getSessionId());
        this.setCookie(LANGUAGE_COOKIE, "en_US");
    }

    public void onFailure(Throwable x, Message[] messages) {
        if (x instanceof ProtocolException) {
            try {
                if (this.salesforceConnector instanceof SalesforceConnector) {
                    ((SalesforceConnector)this.salesforceConnector).reconnect();
                }
                this.setCookies();
                this.handshake();
            }
            catch (ConnectionException e) {
                LOGGER.error((Object)e.getMessage());
            }
        } else {
            LOGGER.error((Object)x.getMessage());
        }
    }

    public void handshake() {
        super.handshake(30000L);
    }

    public void unsubscribe(String channel) {
        this.getChannel(channel).unsubscribe();
        this.subscriptions.remove(channel);
        this.currentSubscriptions.remove(channel);
    }

    public void subscribe(String channel, ClientSessionChannel.MessageListener messageListener) {
        if (this.isConnected()) {
            LOGGER.info((Object)("Subscribing to channel: " + channel));
            this.getChannel(channel).subscribe(messageListener);
        } else {
            this.subscriptions.put(channel, messageListener);
            this.currentSubscriptions.put(channel, messageListener);
        }
    }
}

