/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BulkConnection;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.PicklistEntry;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.MessageHandler;
import com.sforce.ws.SessionRenewer;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.EnumMetaDataBuilder;
import org.mule.common.metadata.datatype.DataType;
import org.mule.modules.salesforce.BaseSalesforceConnector;
import org.mule.modules.salesforce.ProxyAuthenticator;

public class SalesforceConnector
extends BaseSalesforceConnector {
    private static final Logger LOGGER = Logger.getLogger(SalesforceConnector.class);
    private PartnerConnection connection;
    private BulkConnection bulkConnection;
    private LoginResult loginResult;

    public List<MetaDataKey> getMetaDataKeys() throws Exception {
        ArrayList<MetaDataKey> keys = new ArrayList<MetaDataKey>();
        DescribeGlobalResult describeGlobal = this.describeGlobal();
        if (describeGlobal != null) {
            DescribeGlobalSObjectResult[] sobjects;
            for (DescribeGlobalSObjectResult sobject : sobjects = describeGlobal.getSobjects()) {
                keys.add((MetaDataKey)new DefaultMetaDataKey(sobject.getName(), sobject.getLabel(), sobject.isQueryable()));
            }
        }
        return keys;
    }

    public MetaData getMetaData(MetaDataKey key) throws Exception {
        DescribeSObjectResult describeSObject = this.describeSObject(key.getId());
        DefaultMetaData metaData = null;
        if (describeSObject != null) {
            Field[] fields = describeSObject.getFields();
            DynamicObjectBuilder dynamicObject = new DefaultMetaDataBuilder().createDynamicObject(key.getId());
            for (Field f : fields) {
                this.addField(f, dynamicObject);
            }
            MetaDataModel model = dynamicObject.build();
            metaData = new DefaultMetaData(model);
        }
        return metaData;
    }

    private void addField(Field f, DynamicObjectBuilder dynamicObject) {
        DataType dataType = this.getDataType(f.getType());
        switch (dataType) {
            case POJO: {
                dynamicObject.addPojoField(f.getName(), Object.class);
                break;
            }
            case ENUM: {
                EnumMetaDataBuilder enumMetaDataBuilder = dynamicObject.addEnumField(f.getName());
                if (f.getPicklistValues().length == 0) break;
                String[] values = new String[f.getPicklistValues().length];
                int i = 0;
                for (PicklistEntry picklistEntry : f.getPicklistValues()) {
                    values[i] = picklistEntry.getValue();
                    ++i;
                }
                enumMetaDataBuilder.setValues(values).isWhereCapable(f.isFilterable()).isOrderByCapable(f.isSortable());
                break;
            }
            default: {
                dynamicObject.addSimpleField(f.getName(), dataType).isWhereCapable(f.isFilterable()).isOrderByCapable(f.isSortable());
            }
        }
    }

    private DataType getDataType(FieldType fieldType) {
        DataType dt;
        switch (fieldType) {
            case _boolean: {
                dt = DataType.BOOLEAN;
                break;
            }
            case _double: {
                dt = DataType.DOUBLE;
                break;
            }
            case _int: {
                dt = DataType.INTEGER;
                break;
            }
            case anyType: {
                dt = DataType.POJO;
                break;
            }
            case base64: {
                dt = DataType.STRING;
                break;
            }
            case combobox: {
                dt = DataType.ENUM;
                break;
            }
            case currency: {
                dt = DataType.STRING;
                break;
            }
            case datacategorygroupreference: {
                dt = DataType.STRING;
                break;
            }
            case date: {
                dt = DataType.DATE_TIME;
                break;
            }
            case datetime: {
                dt = DataType.DATE_TIME;
                break;
            }
            case email: {
                dt = DataType.STRING;
                break;
            }
            case encryptedstring: {
                dt = DataType.STRING;
                break;
            }
            case id: {
                dt = DataType.STRING;
                break;
            }
            case multipicklist: {
                dt = DataType.ENUM;
                break;
            }
            case percent: {
                dt = DataType.STRING;
                break;
            }
            case phone: {
                dt = DataType.STRING;
                break;
            }
            case picklist: {
                dt = DataType.ENUM;
                break;
            }
            case reference: {
                dt = DataType.STRING;
                break;
            }
            case string: {
                dt = DataType.STRING;
                break;
            }
            case textarea: {
                dt = DataType.STRING;
                break;
            }
            case time: {
                dt = DataType.DATE_TIME;
                break;
            }
            case url: {
                dt = DataType.STRING;
                break;
            }
            default: {
                dt = DataType.STRING;
            }
        }
        return dt;
    }

    protected void setConnection(PartnerConnection connection) {
        this.connection = connection;
    }

    protected void setBulkConnection(BulkConnection bulkConnection) {
        this.bulkConnection = bulkConnection;
    }

    protected void setLoginResult(LoginResult loginResult) {
        this.loginResult = loginResult;
    }

    protected LoginResult getLoginResult() {
        return this.loginResult;
    }

    public boolean isConnected() {
        return this.bulkConnection != null && this.connection != null && this.loginResult != null && this.loginResult.getSessionId() != null;
    }

    @Override
    public String getSessionId() {
        if (this.connection != null && this.loginResult != null) {
            return this.loginResult.getSessionId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroySession() {
        if (this.isInitializedBayeuxClient() && this.getBayeuxClient().isConnected()) {
            this.getBayeuxClient().disconnect();
        }
        if (this.connection != null && this.loginResult != null) {
            try {
                this.connection.logout();
            }
            catch (com.sforce.ws.ConnectionException ce) {
                LOGGER.error((Object)ce);
            }
            finally {
                this.loginResult = null;
                this.connection = null;
                this.setBayeuxClient(null);
            }
        }
    }

    @Override
    protected boolean isReadyToSubscribe() {
        return this.isConnected();
    }

    public void init() {
        this.registerTransformers();
    }

    public synchronized void connect(String username, String password, String securityToken, String url, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String sessionId, String serviceEndpoint) throws ConnectionException {
        ConnectorConfig connectorConfig = this.createConnectorConfig(url, username, password + StringUtils.defaultString((String)securityToken, (String)""), proxyHost, proxyPort, proxyUsername, proxyPassword);
        if (LOGGER.isDebugEnabled()) {
            connectorConfig.addMessageHandler(new MessageHandler(){

                public void handleRequest(URL endpoint, byte[] request) {
                    LOGGER.debug((Object)("Sending request to " + endpoint.toString()));
                    LOGGER.debug((Object)new String(request));
                }

                public void handleResponse(URL endpoint, byte[] response) {
                    LOGGER.debug((Object)("Receiving response from " + endpoint.toString()));
                    LOGGER.debug((Object)new String(response));
                }
            });
        }
        try {
            this.connection = Connector.newConnection(connectorConfig);
            this.setConnectionOptions(this.connection);
        }
        catch (com.sforce.ws.ConnectionException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, e.getMessage(), (Throwable)e);
        }
        if (sessionId != null && serviceEndpoint != null) {
            this.connection.getSessionHeader().setSessionId(sessionId);
            this.connection.getConfig().setSessionId(sessionId);
            this.connection.getConfig().setServiceEndpoint(serviceEndpoint);
        } else {
            this.reconnect();
        }
        try {
            String restEndpoint = "https://" + new URL(connectorConfig.getServiceEndpoint()).getHost() + "/services/async/30.0";
            connectorConfig.setRestEndpoint(restEndpoint);
            this.bulkConnection = new BulkConnection(connectorConfig);
        }
        catch (AsyncApiException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, e.getExceptionCode().toString(), e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN_HOST, null, e.getMessage(), (Throwable)e);
        }
        this.processSubscriptions();
    }

    public void reconnect() throws ConnectionException {
        try {
            LOGGER.debug((Object)("Creating a Salesforce session using " + this.connection.getConfig().getUsername()));
            this.loginResult = this.connection.login(this.connection.getConfig().getUsername(), this.connection.getConfig().getPassword());
            if (this.loginResult.isPasswordExpired()) {
                try {
                    this.connection.logout();
                }
                catch (com.sforce.ws.ConnectionException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                String username = this.connection.getConfig().getUsername();
                this.connection = null;
                throw new ConnectionException(ConnectionExceptionCode.CREDENTIALS_EXPIRED, null, "The password for the user " + username + " has expired");
            }
            LOGGER.debug((Object)("Session established successfully with ID " + this.loginResult.getSessionId() + " at instance " + this.loginResult.getServerUrl()));
            this.connection.getSessionHeader().setSessionId(this.loginResult.getSessionId());
            this.connection.getConfig().setServiceEndpoint(this.loginResult.getServerUrl());
            this.connection.getConfig().setSessionId(this.loginResult.getSessionId());
        }
        catch (com.sforce.ws.ConnectionException e) {
            if (e instanceof ApiFault) {
                throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, ((ApiFault)((Object)e)).getExceptionCode().name(), ((ApiFault)((Object)e)).getExceptionMessage(), (Throwable)e);
            }
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, e.getMessage(), (Throwable)e);
        }
    }

    protected ConnectorConfig createConnectorConfig(String endpoint, String username, String password, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword) {
        ConnectorConfig config = new ConnectorConfig();
        config.setUsername(username);
        config.setPassword(password);
        config.setAuthEndpoint(endpoint);
        config.setServiceEndpoint(endpoint);
        config.setManualLogin(true);
        config.setCompression(false);
        if (proxyHost != null && proxyUsername != null && proxyPassword != null) {
            Authenticator.setDefault(new ProxyAuthenticator(proxyUsername, proxyPassword));
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            config.setProxy(proxy);
        }
        SessionRenewer sessionRenewer = new SessionRenewer(){

            public SessionRenewer.SessionRenewalHeader renewSession(ConnectorConfig config) throws com.sforce.ws.ConnectionException {
                try {
                    SalesforceConnector.this.reconnect();
                }
                catch (ConnectionException e) {
                    throw new com.sforce.ws.ConnectionException(e.getMessage(), (Throwable)e);
                }
                SessionRenewer.SessionRenewalHeader sessionRenewalHeader = new SessionRenewer.SessionRenewalHeader();
                sessionRenewalHeader.name = new QName("urn:partner.soap.sforce.com", "SessionHeader");
                sessionRenewalHeader.headerElement = SalesforceConnector.this.connection.getSessionHeader();
                return sessionRenewalHeader;
            }
        };
        config.setSessionRenewer(sessionRenewer);
        return config;
    }

    @Override
    protected PartnerConnection getConnection() {
        return this.connection;
    }

    @Override
    protected BulkConnection getBulkConnection() {
        return this.bulkConnection;
    }
}

