/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BulkConnection;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.MessageHandler;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.mule.RequestContext;
import org.mule.modules.salesforce.BaseSalesforceConnector;

public class SalesforceOAuthConnector
extends BaseSalesforceConnector {
    private static final Logger LOGGER = Logger.getLogger(SalesforceOAuthConnector.class);
    private PartnerConnection partnerConnection;
    private BulkConnection bulkConnection;
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String instanceId;
    private String userId;

    @Override
    protected boolean isReadyToSubscribe() {
        return this.accessToken != null;
    }

    public void init() {
        this.registerTransformers();
    }

    public void postAuthorize() throws ConnectionException, MalformedURLException, AsyncApiException {
        ConnectorConfig config = new ConnectorConfig();
        if (LOGGER.isDebugEnabled()) {
            config.addMessageHandler(new MessageHandler(){

                public void handleRequest(URL endpoint, byte[] request) {
                    LOGGER.debug((Object)("Sending request to " + endpoint.toString()));
                    LOGGER.debug((Object)new String(request));
                }

                public void handleResponse(URL endpoint, byte[] response) {
                    LOGGER.debug((Object)("Receiving response from " + endpoint.toString()));
                    LOGGER.debug((Object)new String(response));
                }
            });
        }
        config.setSessionId(this.accessToken);
        config.setManualLogin(true);
        config.setCompression(false);
        String serviceEndpoint = "https://" + new URL(this.instanceId).getHost() + "/services/Soap/u/30.0";
        config.setServiceEndpoint(serviceEndpoint);
        this.partnerConnection = Connector.newConnection(config);
        this.setConnectionOptions(this.partnerConnection);
        String restEndpoint = "https://" + new URL(this.instanceId).getHost() + "/services/async/30.0";
        config.setRestEndpoint(restEndpoint);
        this.bulkConnection = new BulkConnection(config);
        this.processSubscriptions();
        RequestContext.getEvent().setFlowVariable("remoteUserId", (Object)this.userId);
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    protected PartnerConnection getConnection() {
        return this.partnerConnection;
    }

    @Override
    protected BulkConnection getBulkConnection() {
        return this.bulkConnection;
    }

    @Override
    protected String getSessionId() {
        return this.accessToken;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

