/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.mule.api.transformer.DataType;
import org.mule.common.bulk.BulkItem;
import org.mule.common.bulk.BulkOperationResult;
import org.mule.modules.salesforce.bulk.EnrichedSaveResult;
import org.mule.modules.salesforce.bulk.EnrichedUpsertResult;
import org.mule.modules.salesforce.exception.SalesforceBulkException;
import org.mule.transformer.types.DataTypeFactory;

public class SalesforceUtils {
    public static final DataType<BulkOperationResult> BULK_OPERATION_RESULT_DATA_TYPE = DataTypeFactory.create(BulkOperationResult.class);

    public static Map<String, Object> toMap(XmlObject xmlObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object value = xmlObject.getValue();
        if (value == null && xmlObject.hasChildren()) {
            Iterator childrenIterator = xmlObject.getChildren();
            while (childrenIterator.hasNext()) {
                XmlObject child = (XmlObject)childrenIterator.next();
                if (child.getValue() != null) {
                    map.put(child.getName().getLocalPart(), child.getValue());
                    continue;
                }
                if (child.getChildren().hasNext()) {
                    SalesforceUtils.putToMultiMap(map, child.getName().getLocalPart(), SalesforceUtils.toMap(child));
                    continue;
                }
                map.put(child.getName().getLocalPart(), null);
            }
        }
        return map;
    }

    public static com.sforce.async.SObject toAsyncSObject(Map<String, Object> map, Integer batchSobjectMaxDepth) {
        com.sforce.async.SObject sObject = batchSobjectMaxDepth != null && batchSobjectMaxDepth != 0 ? new com.sforce.async.SObject(batchSobjectMaxDepth.intValue()) : new com.sforce.async.SObject();
        for (String key : map.keySet()) {
            Object object = map.get(key);
            if (object != null) {
                if (object instanceof Map) {
                    sObject.setFieldReference(key, SalesforceUtils.toAsyncSObject(SalesforceUtils.toSObjectMap((Map)object), batchSobjectMaxDepth));
                    continue;
                }
                if (SalesforceUtils.isDateField(object)) {
                    sObject.setField(key, SalesforceUtils.convertDateToString(object));
                    continue;
                }
                sObject.setField(key, object.toString());
                continue;
            }
            sObject.setField(key, null);
        }
        return sObject;
    }

    public static SObject toSObject(String type, Map<String, Object> map) {
        SObject sObject = new SObject();
        sObject.setType(type);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.equals("fieldsToNull")) {
                sObject.setFieldsToNull((String[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                sObject.setField(key, (Object)SalesforceUtils.toSObject(key, SalesforceUtils.toSObjectMap((Map)entry.getValue())));
                continue;
            }
            sObject.setField(key, entry.getValue());
        }
        return sObject;
    }

    public static Map<String, Object> toSObjectMap(Map map) {
        HashMap<String, Object> sObjectMap = new HashMap<String, Object>();
        for (Object key : map.keySet()) {
            sObjectMap.put(key.toString(), map.get(key));
        }
        return sObjectMap;
    }

    public static com.sforce.async.SObject[] toAsyncSObjectList(List<Map<String, Object>> objects, Integer batchSobjectMaxDepth) {
        com.sforce.async.SObject[] sobjects = new com.sforce.async.SObject[objects.size()];
        int s = 0;
        for (Map<String, Object> map : objects) {
            sobjects[s] = SalesforceUtils.toAsyncSObject(map, batchSobjectMaxDepth);
            ++s;
        }
        return sobjects;
    }

    public static SObject[] toSObjectList(String type, List<Map<String, Object>> objects) {
        SObject[] sobjects = new SObject[objects.size()];
        int s = 0;
        for (Map<String, Object> map : objects) {
            sobjects[s] = SalesforceUtils.toSObject(type, map);
            ++s;
        }
        return sobjects;
    }

    private static void putToMultiMap(Map<String, Object> map, String key, Object newValue) {
        if (map.containsKey(key)) {
            Object value = map.get(key);
            if (value instanceof List) {
                ((List)value).add(newValue);
            } else {
                map.put(key, new ArrayList<Object>(Arrays.asList(value, newValue)));
            }
        } else {
            map.put(key, newValue);
        }
    }

    protected static boolean isDateField(Object object) {
        return object instanceof Date || object instanceof GregorianCalendar || object instanceof Calendar;
    }

    protected static String convertDateToString(Object object) {
        return new DateTime(object).toString();
    }

    public static BulkOperationResult<SObject> saveResultToBulkOperationResult(Collection<SaveResult> results) {
        BulkOperationResult.BulkOperationResultBuilder builder = BulkOperationResult.builder();
        for (SaveResult sr : results) {
            BulkItem.BulkItemBuilder itemBuilder = BulkItem.builder();
            if (sr instanceof EnrichedSaveResult) {
                itemBuilder.setPayload((Object)((EnrichedSaveResult)sr).getPayload());
            }
            if (!sr.isSuccess()) {
                itemBuilder.setException((Exception)new SalesforceBulkException(sr.getErrors()));
            }
            builder.addItem(itemBuilder);
        }
        return builder.build();
    }

    public static BulkOperationResult<SObject> upsertResultToBulkOperationResult(Collection<UpsertResult> results) {
        BulkOperationResult.BulkOperationResultBuilder builder = BulkOperationResult.builder();
        for (UpsertResult ur : results) {
            BulkItem.BulkItemBuilder itemBuilder = BulkItem.builder();
            if (ur instanceof EnrichedUpsertResult) {
                itemBuilder.setPayload((Object)((EnrichedUpsertResult)ur).getPayload());
            }
            if (ur.isSuccess()) {
                itemBuilder.setMessage(ur.isCreated() ? "Created" : "Updated");
            } else {
                itemBuilder.setException((Exception)new SalesforceBulkException(ur.getErrors()));
            }
            builder.addItem(itemBuilder);
        }
        return builder.build();
    }

    public static EnrichedSaveResult enrich(SaveResult saveResut) {
        return new EnrichedSaveResult(saveResut);
    }

    public static EnrichedUpsertResult enrich(UpsertResult upsertResult) {
        return new EnrichedUpsertResult(upsertResult);
    }

    public static EnrichedSaveResult enrichWithPayload(SaveResult saveResult, SObject payload) {
        EnrichedSaveResult enriched = SalesforceUtils.enrich(saveResult);
        enriched.setPayload(payload);
        return enriched;
    }

    public static EnrichedUpsertResult enrichWithPayload(UpsertResult upsertResult, SObject payload) {
        EnrichedUpsertResult enriched = SalesforceUtils.enrich(upsertResult);
        enriched.setPayload(payload);
        return enriched;
    }

    public static List<SaveResult> enrichWithPayload(SObject[] objects, SaveResult[] results) {
        SalesforceUtils.assertResultLength(objects, results);
        ArrayList<SaveResult> enriched = new ArrayList<SaveResult>(results.length);
        for (int i = 0; i < results.length; ++i) {
            enriched.add(SalesforceUtils.enrichWithPayload(results[i], objects[i]));
        }
        return enriched;
    }

    public static List<UpsertResult> enrichWithPayload(SObject[] objects, UpsertResult[] results) {
        SalesforceUtils.assertResultLength(objects, results);
        ArrayList<UpsertResult> enriched = new ArrayList<UpsertResult>(results.length);
        for (int i = 0; i < results.length; ++i) {
            enriched.add(SalesforceUtils.enrichWithPayload(results[i], objects[i]));
        }
        return enriched;
    }

    private static void assertResultLength(SObject[] list, Object[] results) {
        if (list.length != results.length) {
            throw new IllegalStateException(String.format("Protocol exception: Objects and results lists should have the same lenghts. %d and %d found instead", list.length, results.length));
        }
    }
}

