/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.api;

import com.sforce.soap.partner.PartnerConnection;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.mule.modules.salesforce.api.SalesforceExceptionHandlerAdapter;
import org.mule.modules.salesforce.api.SalesforceHeader;

public class SalesforceSoapAdapter {
    private static Logger logger = Logger.getLogger(SalesforceSoapAdapter.class);

    public static PartnerConnection adapt(final PartnerConnection facade, final Map<SalesforceHeader, Object> headers) {
        return (PartnerConnection)Enhancer.create(PartnerConnection.class, (Callback)new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Invoked method %s with arguments %s", method.getName(), Arrays.toString(args)));
                }
                try {
                    PartnerConnection connection = SalesforceSoapAdapter.addHeaders(facade, headers);
                    Object ret = method.invoke((Object)connection, args);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Returned method %s with value %s", ret, Arrays.toString(args)));
                    }
                    return ret;
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Method " + method.getName() + " thew " + e.getClass()));
                    }
                    throw SalesforceExceptionHandlerAdapter.analyzeSoapException(e);
                }
            }
        });
    }

    private static PartnerConnection addHeaders(PartnerConnection partnerConnection, Map<SalesforceHeader, Object> headers) {
        SalesforceSoapAdapter.clearHeaders(partnerConnection);
        if (headers != null) {
            for (Map.Entry<SalesforceHeader, Object> entry : headers.entrySet()) {
                try {
                    if (!Map.class.isAssignableFrom(entry.getValue().getClass())) {
                        logger.error((Object)String.format("The header %s should be a Map", entry.getKey().getHeaderName()));
                        continue;
                    }
                    Object headerObject = entry.getKey().getHeaderClass().newInstance();
                    BeanUtils.populate(headerObject, (Map)((Map)entry.getValue()));
                    partnerConnection.getClass().getMethod("__set" + entry.getKey().getHeaderName(), entry.getKey().getHeaderClass()).invoke((Object)partnerConnection, headerObject);
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Header %s is incorrect, couldn't be added to the request", entry.getKey().toString()));
                }
            }
        }
        return partnerConnection;
    }

    private static void clearHeaders(PartnerConnection partnerConnection) {
        partnerConnection.clearAllOrNoneHeader();
        partnerConnection.clearAllowFieldTruncationHeader();
        partnerConnection.clearAssignmentRuleHeader();
        partnerConnection.clearCallOptions();
        partnerConnection.clearDisableFeedTrackingHeader();
        partnerConnection.clearEmailHeader();
        partnerConnection.clearLocaleOptions();
        partnerConnection.clearMruHeader();
        partnerConnection.clearOwnerChangeOptions();
        partnerConnection.clearQueryOptions();
        partnerConnection.clearUserTerritoryDeleteHeader();
    }
}

