/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.config;

import org.mule.config.MuleManifest;
import org.mule.config.PoolingProfile;
import org.mule.modules.salesforce.connectivity.SalesforceConnectorConnectionManager;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SalesforceConnectorConfigDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(SalesforceConnectorConfigDefinitionParser.class);

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.setScope("singleton");
        this.setInitMethodIfNeeded(builder, SalesforceConnectorConnectionManager.class);
        this.setDestroyMethodIfNeeded(builder, SalesforceConnectorConnectionManager.class);
        if (this.hasAttribute(element, "timeObjectStore-ref")) {
            if (element.getAttribute("timeObjectStore-ref").startsWith("#")) {
                builder.addPropertyValue("timeObjectStore", (Object)element.getAttribute("timeObjectStore-ref"));
            } else {
                builder.addPropertyValue("timeObjectStore", (Object)new RuntimeBeanReference(element.getAttribute("timeObjectStore-ref")));
            }
        }
        this.parseProperty(builder, element, "clientId", "clientId");
        this.parseProperty(builder, element, "assignmentRuleId", "assignmentRuleId");
        this.parseProperty(builder, element, "useDefaultRule", "useDefaultRule");
        this.parseProperty(builder, element, "batchSobjectMaxDepth", "batchSobjectMaxDepth");
        this.parseProperty(builder, element, "allowFieldTruncationSupport", "allowFieldTruncationSupport");
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        this.parseProperty(builder, element, "securityToken", "securityToken");
        this.parseProperty(builder, element, "url", "url");
        this.parseProperty(builder, element, "proxyHost", "proxyHost");
        this.parseProperty(builder, element, "proxyPort", "proxyPort");
        this.parseProperty(builder, element, "proxyUsername", "proxyUsername");
        this.parseProperty(builder, element, "proxyPassword", "proxyPassword");
        this.parseProperty(builder, element, "sessionId", "sessionId");
        this.parseProperty(builder, element, "serviceEndpoint", "serviceEndpoint");
        BeanDefinitionBuilder poolingProfileBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PoolingProfile.class.getName());
        Element poolingProfileElement = DomUtils.getChildElementByTagName((Element)element, (String)"connection-pooling-profile");
        if (poolingProfileElement != null) {
            this.parseProperty(poolingProfileBuilder, poolingProfileElement, "maxActive");
            this.parseProperty(poolingProfileBuilder, poolingProfileElement, "maxIdle");
            this.parseProperty(poolingProfileBuilder, poolingProfileElement, "maxWait");
            if (this.hasAttribute(poolingProfileElement, "exhaustedAction")) {
                poolingProfileBuilder.addPropertyValue("exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS.get(poolingProfileElement.getAttribute("exhaustedAction")));
            }
            if (this.hasAttribute(poolingProfileElement, "initialisationPolicy")) {
                poolingProfileBuilder.addPropertyValue("initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES.get(poolingProfileElement.getAttribute("initialisationPolicy")));
            }
            if (this.hasAttribute(poolingProfileElement, "evictionCheckIntervalMillis")) {
                this.parseProperty(poolingProfileBuilder, poolingProfileElement, "evictionCheckIntervalMillis");
            }
            if (this.hasAttribute(poolingProfileElement, "minEvictionMillis")) {
                this.parseProperty(poolingProfileBuilder, poolingProfileElement, "minEvictionMillis");
            }
            builder.addPropertyValue("poolingProfile", (Object)poolingProfileBuilder.getBeanDefinition());
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-forever", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-custom-strategy", element, parserContext, builder, (BeanDefinition)definition);
        return definition;
    }

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)SalesforceConnectorConnectionManager.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the configuration [config] within the connector [sfdc] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the configuration [config] within the connector [sfdc] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }
}

