/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.lazystream;

import com.sforce.async.BulkConnection;
import java.io.IOException;
import java.io.InputStream;
import org.mule.modules.salesforce.lazystream.LazyInputStreamStates;

public abstract class LazyInputStream
extends InputStream {
    private InputStream inputStream;
    private LazyInputStreamStates inputStreamState;
    private BulkConnection connection;
    private Object inputStreamStateLock;

    public LazyInputStream(BulkConnection connection) {
        this.connection = connection;
        this.inputStreamState = LazyInputStreamStates.PENDING;
        this.inputStreamStateLock = new Object();
    }

    protected BulkConnection getBulkConnection() {
        return this.connection;
    }

    public LazyInputStreamStates getInputStreamState() {
        return this.inputStreamState;
    }

    @Override
    public int read() throws IOException {
        this.openLazyStream();
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.openLazyStream();
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.openLazyStream();
        return this.inputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.openLazyStream();
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.openLazyStream();
        return this.inputStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.inputStreamStateLock;
        synchronized (object) {
            this.inputStreamState = LazyInputStreamStates.CLOSED;
            this.connection = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.openLazyStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.openLazyStream();
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        try {
            this.openLazyStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.inputStream.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openLazyStream() throws IOException {
        Object object = this.inputStreamStateLock;
        synchronized (object) {
            if (this.inputStreamState.equals((Object)LazyInputStreamStates.PENDING)) {
                this.inputStreamState = LazyInputStreamStates.OPENED;
                this.inputStream = this.openLazyInputStream();
            }
        }
    }

    protected abstract InputStream openLazyInputStream() throws IOException;
}

