/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.oauth;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.store.ObjectStore;
import org.mule.modules.salesforce.adapters.SalesforceOAuthConnectorOAuth2Adapter;
import org.mule.modules.salesforce.exception.SalesforceSessionExpiredException;
import org.mule.modules.salesforce.oauth.SalesforceOAuthConnectorOAuthClientFactory;
import org.mule.security.oauth.BaseOAuth2Manager;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceOAuthConnectorOAuthManager
extends BaseOAuth2Manager<OAuth2Adapter> {
    private static Logger logger = LoggerFactory.getLogger(SalesforceOAuthConnectorOAuthManager.class);
    private static final String MODULE_NAME = "Salesforce (OAuth)";
    private static final String MODULE_VERSION = "5.4.8";
    private static final String DEVKIT_VERSION = "3.5.1";
    private static final String DEVKIT_BUILD = "UNNAMED.1967.45d0eb0";

    protected Logger getLogger() {
        return logger;
    }

    public void setConsumerKey(String value) {
        super.setConsumerKey(value);
    }

    public void setConsumerSecret(String value) {
        super.setConsumerSecret(value);
    }

    public void setTimeObjectStore(ObjectStore<? extends Serializable> value) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        connector.setTimeObjectStore(value);
    }

    public ObjectStore<? extends Serializable> getTimeObjectStore() {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return connector.getTimeObjectStore();
    }

    public void setClientId(String value) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        connector.setClientId(value);
    }

    public String getClientId() {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return connector.getClientId();
    }

    public void setAssignmentRuleId(String value) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        connector.setAssignmentRuleId(value);
    }

    public String getAssignmentRuleId() {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return connector.getAssignmentRuleId();
    }

    public void setUseDefaultRule(Boolean value) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        connector.setUseDefaultRule(value);
    }

    public Boolean getUseDefaultRule() {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return connector.getUseDefaultRule();
    }

    public void setBatchSobjectMaxDepth(Integer value) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        connector.setBatchSobjectMaxDepth(value);
    }

    public Integer getBatchSobjectMaxDepth() {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return connector.getBatchSobjectMaxDepth();
    }

    public void setAllowFieldTruncationSupport(Boolean value) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        connector.setAllowFieldTruncationSupport(value);
    }

    public Boolean getAllowFieldTruncationSupport() {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return connector.getAllowFieldTruncationSupport();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    protected OAuth2Adapter instantiateAdapter() {
        return new SalesforceOAuthConnectorOAuth2Adapter((OAuth2Manager<OAuth2Adapter>)this);
    }

    protected KeyedPoolableObjectFactory createPoolFactory(OAuth2Manager<OAuth2Adapter> oauthManager, ObjectStore<Serializable> objectStore) {
        return new SalesforceOAuthConnectorOAuthClientFactory(oauthManager, objectStore);
    }

    protected void setCustomProperties(OAuth2Adapter adapter) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)adapter;
        connector.setConsumerKey(this.getConsumerKey());
        connector.setConsumerSecret(this.getConsumerSecret());
        connector.setTimeObjectStore(this.getTimeObjectStore());
        connector.setClientId(this.getClientId());
        connector.setAssignmentRuleId(this.getAssignmentRuleId());
        connector.setUseDefaultRule(this.getUseDefaultRule());
        connector.setBatchSobjectMaxDepth(this.getBatchSobjectMaxDepth());
        connector.setAllowFieldTruncationSupport(this.getAllowFieldTruncationSupport());
    }

    protected void fetchCallbackParameters(OAuth2Adapter adapter, String response) {
        SalesforceOAuthConnectorOAuth2Adapter connector = (SalesforceOAuthConnectorOAuth2Adapter)adapter;
        ExpressionManager expressionManager = this.muleContext.getExpressionManager();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)response, this.muleContext);
        connector.setInstanceId((String)expressionManager.evaluate("#[json:instance_url]", (MuleMessage)muleMessage));
        connector.setUserId((String)expressionManager.evaluate("#[json:id]", (MuleMessage)muleMessage));
    }

    public void setOnNoToken(OnNoTokenPolicy policy) {
        this.getDefaultUnauthorizedConnector().setOnNoTokenPolicy(policy);
    }

    protected Set<Class<? extends Exception>> refreshAccessTokenOn() {
        HashSet<Class<? extends Exception>> types = new HashSet<Class<? extends Exception>>();
        types.add(SalesforceSessionExpiredException.class);
        return types;
    }
}

