/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.processors;

import com.sforce.async.BatchInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.common.metadata.key.property.MetaDataKeyProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.modules.salesforce.BaseSalesforceConnector;
import org.mule.modules.salesforce.connectivity.SalesforceConnectorConnectionManager;
import org.mule.modules.salesforce.exception.SalesforceSessionExpiredException;
import org.mule.modules.salesforce.processors.AbstractConnectedProcessor;
import org.mule.security.oauth.callback.ProcessCallback;

public class UpdateBulkMessageProcessor
extends AbstractConnectedProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object type;
    protected String _typeType;
    protected Object objects;
    protected List<Map<String, Object>> _objectsType;

    public UpdateBulkMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void setType(Object value) {
        this.type = value;
    }

    public void setObjects(Object value) {
        this.objects = value;
    }

    public MuleEvent doProcess(MuleEvent event) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(ProcessAdapter.class, false, event);
        final String _transformedType = (String)this.evaluateAndTransform(this.getMuleContext(), event, UpdateBulkMessageProcessor.class.getDeclaredField("_typeType").getGenericType(), null, this.type);
        final List _transformedObjects = (List)this.evaluateAndTransform(this.getMuleContext(), event, UpdateBulkMessageProcessor.class.getDeclaredField("_objectsType").getGenericType(), null, this.objects);
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return Arrays.asList(SalesforceSessionExpiredException.class, SalesforceSessionExpiredException.class);
            }

            public boolean isProtected() {
                return true;
            }

            public Object process(Object object) throws Exception {
                return ((BaseSalesforceConnector)object).updateBulk(_transformedType, _transformedObjects);
            }
        }, (MessageProcessor)this, event);
        event.getMessage().setPayload(resultPayload);
        return event;
    }

    public Result<MetaData> getInputMetaData() {
        if (this.type == null || this.type.toString() == null) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving metadata from parameter: type at processor updateBulk at module SalesforceConnector");
        }
        DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey(this.type.toString(), null);
        metaDataKey.addProperty((MetaDataKeyProperty)new TypeDescribingProperty(TypeDescribingProperty.TypeScope.INPUT, "updateBulk"));
        Result<MetaData> genericMetaData = this.getGenericMetaData((MetaDataKey)metaDataKey);
        if (Result.Status.FAILURE.equals((Object)genericMetaData.getStatus())) {
            return genericMetaData;
        }
        return new DefaultResult((Object)new DefaultMetaData((MetaDataModel)new DefaultListMetaDataModel(((MetaData)genericMetaData.get()).getPayload())));
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult((Object)new DefaultMetaData(this.getPojoOrSimpleModel(BatchInfo.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(SalesforceConnectorConnectionManager.class, true, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at SalesforceConnector at updateBulk retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

