/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.util.Preconditions;

final class ExtensionStateTracker {
    private final Map<String, ConfigurationInstanceProvider<?>> configurationInstanceProviders = new ConcurrentHashMap();
    private final Map<String, Object> configurationInstances = new ConcurrentHashMap<String, Object>();

    ExtensionStateTracker() {
    }

    <C> void registerConfigurationInstanceProvider(String key, ConfigurationInstanceProvider<C> configurationInstanceProvider) {
        this.idempotentPut(this.configurationInstanceProviders, key, configurationInstanceProvider);
    }

    <C> ConfigurationInstanceProvider<C> getConfigurationInstanceProvider(String configurationInstanceProviderName) {
        return this.configurationInstanceProviders.get(configurationInstanceProviderName);
    }

    List<ConfigurationInstanceProvider<?>> getConfigurationInstanceProviders() {
        return ImmutableList.copyOf(this.configurationInstanceProviders.values());
    }

    <C> void registerConfigurationInstance(String instanceKey, C configurationInstance) {
        this.idempotentPut(this.configurationInstances, instanceKey, configurationInstance);
    }

    private <K, V> void idempotentPut(Map<K, V> map, K key, V value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        if (map.containsKey(key)) {
            throw new IllegalStateException(String.format("A %s is already registered for the name '%s'", value.getClass().getSimpleName(), key));
        }
        map.put(key, value);
    }
}

