/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.module.extension.internal.runtime.ObjectBuilder;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.mule.util.Preconditions;
import org.springframework.util.ReflectionUtils;

abstract class BaseObjectBuilder<T>
implements ObjectBuilder<T> {
    private final Map<Field, ValueResolver<Object>> resolvers = new HashMap<Field, ValueResolver<Object>>();

    BaseObjectBuilder() {
    }

    protected abstract T instantiateObject();

    @Override
    public ObjectBuilder<T> addPropertyResolver(Field field, ValueResolver<? extends Object> resolver) {
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"field cannot be null");
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"resolver cannot be null");
        field.setAccessible(true);
        this.resolvers.put(field, resolver);
        return this;
    }

    @Override
    public boolean isDynamic() {
        return MuleExtensionUtils.hasAnyDynamic(this.resolvers.values());
    }

    @Override
    public T build(MuleEvent event) throws MuleException {
        T object = this.instantiateObject();
        for (Map.Entry<Field, ValueResolver<Object>> resolver : this.resolvers.entrySet()) {
            ReflectionUtils.setField((Field)resolver.getKey(), object, (Object)resolver.getValue().resolve(event));
        }
        return object;
    }
}

